/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerRepository;
import org.apache.isis.runtimes.dflt.runtime.userprofile.UserProfileStoreInstaller;

public class OptionHandlerUserProfileStore
extends OptionHandlerAbstract {
    private final InstallerRepository installerRepository;
    private String userProfileStoreName;

    public OptionHandlerUserProfileStore(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addOption(Options options) {
        Object[] persistenceMechanisms = this.installerRepository.getInstallers(UserProfileStoreInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"user-profile-store");
        OptionBuilder.withDescription((String)("user profile store to use: " + this.availableInstallers(persistenceMechanisms) + "; or class name"));
        Option option = OptionBuilder.create((String)"e");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.userProfileStoreName = commandLine.getOptionValue("e");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        isisConfigurationBuilder.add("isis.user-profile-store", this.userProfileStoreName);
    }

    public String getUserProfileStoreName() {
        return this.userProfileStoreName;
    }
}

