/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.isis.core.commons.config.IsisConfigurationBuilder;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.core.runtime.optionhandler.BootPrinter;
import org.apache.isis.core.runtime.optionhandler.OptionHandlerAbstract;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerRepository;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.IsisViewerInstaller;

public class OptionHandlerViewer
extends OptionHandlerAbstract {
    private final InstallerRepository installerRepository;
    private List<String> viewerNames;

    public OptionHandlerViewer(InstallerRepository installerRepository) {
        this.installerRepository = installerRepository;
    }

    public void addOption(Options options) {
        Object[] viewers = this.installerRepository.getInstallers(IsisViewerInstaller.class);
        OptionBuilder.withArgName((String)"name|class name");
        OptionBuilder.hasArg();
        OptionBuilder.withLongOpt((String)"viewer");
        OptionBuilder.withDescription((String)("viewer to use, or for server to listen on: " + this.availableInstallers(viewers) + "; or class name"));
        Option option = OptionBuilder.create((String)"v");
        options.addOption(option);
    }

    public boolean handle(CommandLine commandLine, BootPrinter bootPrinter, Options options) {
        this.viewerNames = this.getOptionValues(commandLine, "v");
        return true;
    }

    public void primeConfigurationBuilder(IsisConfigurationBuilder isisConfigurationBuilder) {
        isisConfigurationBuilder.add("isis.viewer", ListUtils.listToString(this.viewerNames));
    }

    public List<String> getViewerNames() {
        return this.viewerNames;
    }
}

