/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import java.util.List;
import org.apache.isis.applib.maybe.Maybe;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerConnector;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidator;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.Strings;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;

public final class OptionValidatorForConnector
implements OptionValidator {
    private final OptionHandlerConnector optionHandlerClientConnection;

    public OptionValidatorForConnector(OptionHandlerConnector optionHandlerClientConnection) {
        this.optionHandlerClientConnection = optionHandlerClientConnection;
    }

    @Override
    public Maybe<String> validate(DeploymentType deploymentType) {
        List<String> connectorNames = this.optionHandlerClientConnection.getConnectorNames();
        boolean fail = !deploymentType.canSpecifyConnectors(connectorNames);
        String failMsg = String.format("Error: cannot specify %s connector%s for deployment type %s\n", Strings.plural(connectorNames, "more than one", "any"), Strings.plural(connectorNames, "", "s"), deploymentType.nameLowerCase());
        return Maybe.setIf((boolean)fail, (Object)failMsg);
    }
}

