/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import org.apache.isis.applib.maybe.Maybe;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerPersistor;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidator;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;

public final class OptionValidatorForPersistor
implements OptionValidator {
    private final OptionHandlerPersistor optionHandlerPersistor;

    public OptionValidatorForPersistor(OptionHandlerPersistor optionHandlerPersistor) {
        this.optionHandlerPersistor = optionHandlerPersistor;
    }

    @Override
    public Maybe<String> validate(DeploymentType deploymentType) {
        String objectPersistorName = this.optionHandlerPersistor.getPersistorName();
        boolean fail = !StringUtils.isNullOrEmpty((String)objectPersistorName) && !deploymentType.canSpecifyObjectStore();
        String failMsg = String.format("Error: cannot specify an object store (persistor) for deployment type %s\n", deploymentType.name().toLowerCase());
        return Maybe.setIf((boolean)fail, (Object)failMsg);
    }
}

