/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.runner.opts;

import java.util.List;
import org.apache.isis.applib.maybe.Maybe;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionHandlerViewer;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.OptionValidator;
import org.apache.isis.runtimes.dflt.runtime.runner.opts.Strings;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;

public final class OptionValidatorForViewers
implements OptionValidator {
    private final OptionHandlerViewer optionHandlerViewer;

    public OptionValidatorForViewers(OptionHandlerViewer optionHandlerViewer) {
        this.optionHandlerViewer = optionHandlerViewer;
    }

    @Override
    public Maybe<String> validate(DeploymentType deploymentType) {
        List<String> viewerNames = this.optionHandlerViewer.getViewerNames();
        boolean fail = !deploymentType.canSpecifyViewers(viewerNames);
        String failMsg = String.format("Error: cannot specify %s viewer%s for deployment type %s\n", Strings.plural(viewerNames, "more than one", "any"), Strings.plural(viewerNames, "", "s"), deploymentType.nameLowerCase());
        return Maybe.setIf((boolean)fail, (Object)failMsg);
    }
}

