/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.services;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.isis.core.commons.config.InstallerAbstract;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.factory.InstanceCreationClassException;
import org.apache.isis.core.commons.factory.InstanceCreationException;
import org.apache.isis.core.commons.lang.ArrayUtils;
import org.apache.isis.core.commons.lang.ListUtils;
import org.apache.isis.runtimes.dflt.runtime.fixturedomainservice.ObjectFixtureService;
import org.apache.isis.runtimes.dflt.runtime.services.InitialisationException;
import org.apache.isis.runtimes.dflt.runtime.services.ServicesInstaller;
import org.apache.isis.runtimes.dflt.runtime.services.SimpleRepository;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.log4j.Logger;

public class ServicesInstallerFromConfiguration
extends InstallerAbstract
implements ServicesInstaller {
    private static final Logger LOG = Logger.getLogger(ServicesInstallerFromConfiguration.class);
    private static final String SERVICES = "services";
    private static final String EXPLORATION_OBJECTS = "exploration-objects";
    private static final String SERVICES_PREFIX = "services.prefix";
    private static final char DELIMITER = '#';

    public ServicesInstallerFromConfiguration() {
        super("services-installer", "configuration");
    }

    @Override
    public List<Object> getServices(DeploymentType deploymentType) {
        LOG.info((Object)("installing " + this.getClass().getName()));
        Object[] common = this.createServices(this.getConfiguration(), null);
        Object[] specific = this.createServices(this.getConfiguration(), deploymentType.name());
        Object[] combined = ArrayUtils.combine((Object[][])new Object[][]{common, specific});
        if (combined.length == 0) {
            throw new InitialisationException("No services specified");
        }
        return ListUtils.asList((Object[])combined);
    }

    private Object[] createServices(IsisConfiguration configuration, String group) {
        DeploymentType deploymentType;
        String root = "isis." + (group == null ? "" : group.toLowerCase() + ".");
        String servicePrefix = configuration.getString(root + SERVICES_PREFIX);
        if (group != null && servicePrefix == null) {
            servicePrefix = configuration.getString("isis.services.prefix");
        }
        String prefix = ServicesInstallerFromConfiguration.servicePrefix(servicePrefix);
        String serviceList = configuration.getString(root + SERVICES);
        List<Object> list = serviceList != null ? this.createServices(prefix, serviceList) : new ArrayList();
        if (configuration.getBoolean(root + EXPLORATION_OBJECTS) && (deploymentType = DeploymentType.lookup(configuration.getString("isis.deploymentType"))).isExploring()) {
            list.add(new ObjectFixtureService());
        }
        Object[] array = list.toArray(new Object[list.size()]);
        return array;
    }

    private List<Object> createServices(String servicePrefix, String serviceList) {
        StringTokenizer services = new StringTokenizer(serviceList, ",");
        if (!services.hasMoreTokens()) {
            throw new InitialisationException("Services specified, but none loaded");
        }
        ArrayList<Object> list = new ArrayList<Object>();
        while (services.hasMoreTokens()) {
            String serviceName = services.nextToken().trim();
            if (serviceName.equals("")) continue;
            LOG.info((Object)("creating service " + serviceName));
            Object service = serviceName.indexOf(35) == -1 ? this.createService(servicePrefix + serviceName) : this.createSimpleRepository(servicePrefix, serviceName);
            list.add(service);
        }
        return list;
    }

    private Object createSimpleRepository(String prefix, String name) {
        int pos = name.indexOf(35);
        String type = name.substring(0, pos);
        if (!"repository".equals(type)) {
            throw new InitialisationException(String.format("Unknown service type '%s'", type));
        }
        String className = prefix + name.substring(pos + 1);
        Class<?> underlying = ServicesInstallerFromConfiguration.loadClass(className);
        return new SimpleRepository(underlying);
    }

    private Object createService(String className) {
        Class<?> loadedClass = ServicesInstallerFromConfiguration.loadClass(className);
        return ServicesInstallerFromConfiguration.createInstance(loadedClass);
    }

    private static String servicePrefix(String servicePrefix) {
        String prefix;
        String string = prefix = servicePrefix == null ? "" : servicePrefix.trim();
        if (prefix.length() > 0 && !prefix.endsWith(".")) {
            prefix = prefix + ".";
        }
        return prefix;
    }

    private static Class<?> loadClass(String className) {
        try {
            LOG.debug((Object)("loading class for service: " + className));
            return Thread.currentThread().getContextClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            throw new InitialisationException(String.format("Cannot find class '%s' for service", className));
        }
    }

    private static <T> T createInstance(Class<T> serviceType) {
        try {
            return serviceType.newInstance();
        }
        catch (NoClassDefFoundError e) {
            throw new InstanceCreationClassException("Class found '" + serviceType + "', but is missing a dependent class", (Throwable)e);
        }
        catch (InstantiationException e) {
            throw new InstanceCreationException("Could not instantiate an object of class '" + serviceType.getName() + "'; " + e.getMessage());
        }
        catch (IllegalAccessException e) {
            throw new InstanceCreationException("Could not access the class '" + serviceType.getName() + "'; " + e.getMessage());
        }
    }

    public List<Class<?>> getTypes() {
        return ServicesInstallerFromConfiguration.listOf((Class[])new Class[]{List.class});
    }
}

