/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.services;

import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.runtimes.dflt.runtime.services.RepositoryHelper;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

public final class SimpleRepository {
    private final Class<?> type;
    private ObjectSpecification spec;

    public SimpleRepository(Class<?> cls) {
        this.type = cls;
    }

    public String getId() {
        return "repository#" + this.getClass().getName();
    }

    public String iconName() {
        return this.getSpec().getShortIdentifier();
    }

    public String title() {
        return this.getSpec().getPluralName();
    }

    public String toString() {
        ToString str = new ToString((Object)this);
        str.append("class", this.type.getName());
        return str.toString();
    }

    public Object[] allInstances() {
        return RepositoryHelper.allInstances(this.getSpec(), this.type);
    }

    public String disableAllInstances() {
        return this.hasInstances() ? null : "No " + this.getSpec().getPluralName();
    }

    public Object[] findByTitle(String title) {
        return RepositoryHelper.findByTitle(this.getSpec(), this.type, title).toArray();
    }

    public String disableFindByTitle() {
        return this.disableAllInstances();
    }

    public static String[] parameterNamesFindByTitle() {
        return new String[]{"Title to find"};
    }

    public static boolean[] parametersRequiredFindByTitle() {
        return new boolean[]{true};
    }

    private boolean hasInstances() {
        return RepositoryHelper.hasInstances(this.getSpec());
    }

    public Object newPersistentInstance() {
        ObjectAdapter adapter = this.getPersistenceSession().createInstance(this.getSpec());
        this.getPersistenceSession().makePersistent(adapter);
        return adapter.getObject();
    }

    public Object newTransientInstance() {
        return this.getPersistenceSession().createInstance(this.getSpec()).getObject();
    }

    protected ObjectSpecification getSpec() {
        if (this.spec == null) {
            this.spec = IsisContext.getSpecificationLoader().loadSpecification(this.type);
        }
        return this.spec;
    }

    public static boolean alwaysHideSpec() {
        return true;
    }

    private PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

