/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.snapshot;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.applib.snapshot.Snapshottable;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.runtime.snapshot.XmlSchema;
import org.apache.isis.core.runtime.snapshot.XmlSnapshot;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

public class XmlSnapshotBuilder {
    private final Snapshottable snapshottable;
    private XmlSchema schema;
    private final List<PathAndAnnotation> paths = Lists.newArrayList();

    public XmlSnapshotBuilder(Snapshottable domainObject) {
        this.snapshottable = domainObject;
    }

    public XmlSnapshotBuilder usingSchema(XmlSchema schema) {
        this.schema = schema;
        return this;
    }

    public XmlSnapshotBuilder includePath(String path) {
        return this.includePathAndAnnotation(path, null);
    }

    public XmlSnapshotBuilder includePathAndAnnotation(String path, String annotation) {
        this.paths.add(new PathAndAnnotation(path, annotation));
        return this;
    }

    public XmlSnapshot build() {
        ObjectAdapter adapter = XmlSnapshotBuilder.getAdapterMap().adapterFor((Object)this.snapshottable);
        XmlSnapshot snapshot = this.schema != null ? new XmlSnapshot(adapter, this.schema) : new XmlSnapshot(adapter);
        for (PathAndAnnotation paa : this.paths) {
            if (paa.annotation != null) {
                snapshot.include(paa.path, paa.annotation);
                continue;
            }
            snapshot.include(paa.path);
        }
        return snapshot;
    }

    private static AdapterMap getAdapterMap() {
        return XmlSnapshotBuilder.getPersistenceSession().getAdapterManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }

    static class PathAndAnnotation {
        private final String path;
        private final String annotation;

        public PathAndAnnotation(String path, String annotation) {
            this.path = path;
            this.annotation = annotation;
        }
    }
}

