/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.system;

import com.google.common.collect.Lists;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.runtimes.dflt.runtime.system.ContextCategory;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentCategory;
import org.apache.isis.runtimes.dflt.runtime.system.Splash;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;

public class DeploymentType {
    private static List<DeploymentType> deploymentTypes = Lists.newArrayList();
    public static DeploymentType EXPLORATION = new DeploymentType("EXPLORATION", DeploymentCategory.EXPLORING, ContextCategory.STATIC_RELAXED, "dnd", Splash.SHOW);
    public static DeploymentType PROTOTYPE = new DeploymentType("PROTOTYPE", DeploymentCategory.PROTOTYPING, ContextCategory.STATIC_RELAXED, "dnd", Splash.SHOW);
    public static DeploymentType CLIENT = new DeploymentType("CLIENT", DeploymentCategory.PRODUCTION, ContextCategory.STATIC, "dnd", Splash.SHOW);
    public static DeploymentType SERVER = new DeploymentType("SERVER", DeploymentCategory.PRODUCTION, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW);
    public static DeploymentType SERVER_EXPLORATION = new DeploymentType("SERVER_EXPLORATION", DeploymentCategory.EXPLORING, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW);
    public static DeploymentType SERVER_PROTOTYPE = new DeploymentType("SERVER_PROTOTYPE", DeploymentCategory.PROTOTYPING, ContextCategory.THREADLOCAL, null, Splash.NO_SHOW);
    public static DeploymentType SINGLE_USER = new DeploymentType("SINGLE_USER", DeploymentCategory.PRODUCTION, ContextCategory.STATIC, "dnd", Splash.NO_SHOW);
    public static DeploymentType UTILITY = new DeploymentType("UTILITY", DeploymentCategory.EXPLORING, ContextCategory.STATIC, null, Splash.NO_SHOW);
    private final String name;
    private final DeploymentCategory deploymentCategory;
    private final ContextCategory contextCategory;
    private final String defaultViewer;
    private final Splash splash;

    public DeploymentType(String name, DeploymentCategory category, ContextCategory contextCategory, String defaultViewer, Splash splash) {
        this.deploymentCategory = category;
        this.contextCategory = contextCategory;
        this.defaultViewer = defaultViewer;
        this.splash = splash;
        this.name = name;
        deploymentTypes.add(this);
    }

    public DebuggableWithTitle getDebug() {
        return new DebuggableWithTitle(){

            public void debugData(DebugBuilder debug) {
                debug.appendln("Category", (Object)DeploymentType.this.deploymentCategory);
                debug.appendln("Context", (Object)DeploymentType.this.contextCategory);
                debug.appendln("Default viewer", (Object)(DeploymentType.this.defaultViewer == null ? "none" : DeploymentType.this.defaultViewer));
                debug.appendln("Show splash", (Object)DeploymentType.this.splash);
                debug.appendln();
                debug.appendln("Name", (Object)DeploymentType.this.friendlyName());
                debug.appendln("Can specify object store", DeploymentType.this.canSpecifyObjectStore());
                debug.appendln("Can install fixtures", DeploymentType.this.canInstallFixtures());
                debug.appendln("Should monitor", DeploymentType.this.shouldMonitor());
            }

            public String debugTitle() {
                return "Deployment type";
            }
        };
    }

    public void initContext(IsisSessionFactory sessionFactory) {
        this.contextCategory.initContext(sessionFactory);
    }

    public boolean canSpecifyViewers(List<String> viewers) {
        return this.contextCategory.canSpecifyViewers(viewers);
    }

    public boolean canSpecifyConnectors(List<String> connectors) {
        return connectors.size() == 0 || this == CLIENT;
    }

    public boolean canSpecifyObjectStore() {
        return this != CLIENT;
    }

    public boolean canInstallFixtures() {
        return this != CLIENT;
    }

    public boolean shouldShowSplash() {
        return this.splash.isShow();
    }

    public boolean shouldMonitor() {
        return this == SERVER && this.isProduction();
    }

    public boolean isExploring() {
        return this.deploymentCategory == DeploymentCategory.EXPLORING;
    }

    public boolean isPrototyping() {
        return this.deploymentCategory == DeploymentCategory.PROTOTYPING;
    }

    public boolean isProduction() {
        return this.deploymentCategory == DeploymentCategory.PRODUCTION;
    }

    public void addDefaultViewer(List<String> requestedViewers) {
        if (requestedViewers.size() == 0 && this.defaultViewer != null) {
            requestedViewers.add(this.defaultViewer);
        }
    }

    public static DeploymentType lookup(String str) {
        String underscoredStr = str.replace('-', '_').toUpperCase();
        for (DeploymentType deploymentType : deploymentTypes) {
            if (!underscoredStr.equals(deploymentType.name())) continue;
            return deploymentType;
        }
        throw new IllegalArgumentException(String.format("Unknown deployment type '%s'", str));
    }

    public String friendlyName() {
        return this.nameLowerCase().replace('_', '-');
    }

    public String nameLowerCase() {
        return this.name().toLowerCase();
    }

    public String name() {
        return this.name;
    }
}

