/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.system.context;

import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContextMultiUser;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSession;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;

public class IsisContextPipe
extends IsisContextMultiUser {
    private IsisSession clientSession;
    private IsisSession serverSession;
    private Thread server;

    public static IsisContext createInstance(IsisSessionFactory sessionFactory) {
        return new IsisContextPipe(sessionFactory);
    }

    private IsisContextPipe(IsisSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    public void setServer(Thread server) {
        this.server = server;
    }

    private boolean isCurrentThreadServer() {
        return Thread.currentThread() == this.server;
    }

    @Override
    protected IsisSession getSessionInstance(String sessionId) {
        return null;
    }

    @Override
    public IsisSession getSessionInstance() {
        if (this.isCurrentThreadServer()) {
            return this.serverSession;
        }
        return this.clientSession;
    }

    @Override
    public IsisSession openSessionInstance(AuthenticationSession authenticationSession) {
        this.applySessionClosePolicy();
        IsisSession newSession = this.getSessionFactoryInstance().openSession(authenticationSession);
        if (this.isCurrentThreadServer()) {
            this.serverSession = newSession;
        } else {
            this.clientSession = newSession;
        }
        return newSession;
    }

    @Override
    public void closeAllSessionsInstance() {
    }

    @Override
    public String[] allSessionIds() {
        return new String[]{this.clientSession.getId(), this.serverSession.getId()};
    }

    public String debugTitle() {
        return "Isis (pipe) " + Thread.currentThread().getName();
    }

    @Override
    public void debugData(DebugBuilder debug) {
        super.debugData(debug);
        debug.appendln("Server thread", (Object)this.server);
    }
}

