/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.system.context;

import java.util.HashMap;
import java.util.Map;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContextMultiUser;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSession;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;
import org.apache.log4j.Logger;

public class IsisContextThreadLocal
extends IsisContextMultiUser {
    private static final Logger LOG = Logger.getLogger(IsisContextThreadLocal.class);
    private final Map<Thread, IsisSession> sessionsByThread = new HashMap<Thread, IsisSession>();

    public static IsisContext createInstance(IsisSessionFactory sessionFactory) {
        return new IsisContextThreadLocal(sessionFactory);
    }

    protected IsisContextThreadLocal(IsisSessionFactory sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void closeAllSessionsInstance() {
        this.shutdownAllThreads();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownAllThreads() {
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            int i = 0;
            for (Thread thread : this.sessionsByThread.keySet()) {
                LOG.info((Object)("Shutting down thread: " + i++));
                IsisSession data = this.sessionsByThread.get(thread);
                data.closeAll();
            }
        }
    }

    @Override
    protected void doClose() {
        this.sessionsByThread.remove(Thread.currentThread());
    }

    @Override
    public String[] allSessionIds() {
        String[] ids = new String[this.sessionsByThread.size()];
        int i = 0;
        for (Thread thread : this.sessionsByThread.keySet()) {
            IsisSession data = this.sessionsByThread.get(thread);
            ids[i++] = data.getId();
        }
        return ids;
    }

    public String debugTitle() {
        return "Isis (by thread) " + Thread.currentThread().getName();
    }

    @Override
    public void debugData(DebugBuilder debug) {
        super.debugData(debug);
        debug.appendln();
        debug.appendTitle("Threads based Contexts");
        for (Thread thread : this.sessionsByThread.keySet()) {
            IsisSession data = this.sessionsByThread.get(thread);
            debug.appendln(thread.toString(), (Object)data);
        }
    }

    @Override
    protected IsisSession getSessionInstance(String executionContextId) {
        for (Thread thread : this.sessionsByThread.keySet()) {
            IsisSession data = this.sessionsByThread.get(thread);
            if (!data.getId().equals(executionContextId)) continue;
            return data;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IsisSession openSessionInstance(AuthenticationSession authenticationSession) {
        Thread thread = Thread.currentThread();
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            this.applySessionClosePolicy();
            IsisSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
            LOG.debug((Object)("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName()));
            this.saveSession(thread, session);
            session.open();
            return session;
        }
    }

    protected IsisSession createAndOpenSession(Thread thread, AuthenticationSession authenticationSession) {
        IsisSession session = this.getSessionFactoryInstance().openSession(authenticationSession);
        session.open();
        LOG.info((Object)("  opening session " + session + " (count " + this.sessionsByThread.size() + ") for " + authenticationSession.getUserName()));
        return session;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IsisSession saveSession(Thread thread, IsisSession session) {
        Map<Thread, IsisSession> map = this.sessionsByThread;
        synchronized (map) {
            this.sessionsByThread.put(thread, session);
        }
        LOG.debug((Object)("  saving session " + session + "; now have " + this.sessionsByThread.size() + " sessions"));
        return session;
    }

    @Override
    public IsisSession getSessionInstance() {
        Thread thread = Thread.currentThread();
        IsisSession session = this.sessionsByThread.get(thread);
        return session;
    }
}

