/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.system.session;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.SessionScopedComponent;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebugString;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSession;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransaction;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IsisSessionDefault
implements IsisSession {
    private static final Logger LOG = Logger.getLogger(IsisSessionDefault.class);
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM HH:mm:ss,SSS");
    private static int nextId = 1;
    private final IsisSessionFactory executionContextFactory;
    private final AuthenticationSession authenticationSession;
    private PersistenceSession persistenceSession;
    private final UserProfile userProfile;
    private final int id;
    private long accessTime;
    private String debugSnapshot;

    public IsisSessionDefault(IsisSessionFactory sessionFactory, AuthenticationSession authenticationSession, PersistenceSession persistenceSession, UserProfile userProfile) {
        Ensure.ensureThatArg((Object)sessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"execution context factory is required");
        Ensure.ensureThatArg((Object)authenticationSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"authentication session is required");
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistence session is required");
        Ensure.ensureThatArg((Object)userProfile, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"user profile is required");
        this.executionContextFactory = sessionFactory;
        this.authenticationSession = authenticationSession;
        this.persistenceSession = persistenceSession;
        this.userProfile = userProfile;
        this.setSessionOpenTime(System.currentTimeMillis());
        this.id = nextId++;
    }

    public void open() {
        this.persistenceSession.open();
    }

    public void close() {
        this.takeSnapshot();
        this.getPersistenceSession().close();
    }

    @Override
    public void closeAll() {
        this.close();
        this.shutdownIfRequired(this.persistenceSession);
    }

    private void shutdownIfRequired(Object o) {
        if (o instanceof SessionScopedComponent) {
            SessionScopedComponent requiresSetup = (SessionScopedComponent)o;
            requiresSetup.close();
        }
    }

    @Override
    public IsisSessionFactory getSessionFactory() {
        return this.executionContextFactory;
    }

    public DeploymentType getDeploymentType() {
        return this.executionContextFactory.getDeploymentType();
    }

    public IsisConfiguration getConfiguration() {
        return this.executionContextFactory.getConfiguration();
    }

    public SpecificationLoader getSpecificationLoader() {
        return this.executionContextFactory.getSpecificationLoader();
    }

    public TemplateImageLoader getTemplateImageLoader() {
        return this.executionContextFactory.getTemplateImageLoader();
    }

    @Override
    public AuthenticationSession getAuthenticationSession() {
        return this.authenticationSession;
    }

    private String getSessionUserName() {
        return this.getAuthenticationSession().getUserName();
    }

    @Override
    public String getId() {
        return "#" + this.id + this.getSessionUserName();
    }

    @Override
    public PersistenceSession getPersistenceSession() {
        return this.persistenceSession;
    }

    @Override
    public UserProfile getUserProfile() {
        return this.userProfile;
    }

    protected long getSessionOpenTime() {
        return this.accessTime;
    }

    private void setSessionOpenTime(long accessTime) {
        this.accessTime = accessTime;
    }

    @Override
    public IsisTransaction getCurrentTransaction() {
        return this.getTransactionManager().getTransaction();
    }

    public void testSetObjectPersistor(PersistenceSession objectPersistor) {
        this.persistenceSession = objectPersistor;
    }

    public String toString() {
        ToString asString = new ToString((Object)this);
        asString.append("context", this.getId());
        this.appendState(asString);
        return asString.toString();
    }

    @Override
    public void debugAll(DebugBuilder debug) {
        debug.startSection("Isis Context Snapshot");
        debug.appendln(this.debugSnapshot);
        debug.endSection();
    }

    @Override
    public void debug(DebugBuilder debug) {
        debug.appendAsHexln("hash", (long)this.hashCode());
        debug.appendln("context id", (long)this.id);
        debug.appendln("accessed", (Object)DATE_FORMAT.format(new Date(this.getSessionOpenTime())));
        this.debugState(debug);
    }

    public void takeSnapshot() {
        if (!LOG.isDebugEnabled()) {
            return;
        }
        DebugString debug = new DebugString();
        this.debug((DebugBuilder)debug);
        debug.indent();
        debug.appendln();
        this.debug((DebugBuilder)debug, this.getPersistenceSession());
        if (this.getCurrentTransaction() != null) {
            this.debug((DebugBuilder)debug, this.getCurrentTransaction().getUpdateNotifier());
            this.debug((DebugBuilder)debug, this.getCurrentTransaction().getMessageBroker());
        }
        this.debugSnapshot = debug.toString();
        LOG.debug((Object)this.debugSnapshot);
    }

    private void debug(DebugBuilder debug, Object object) {
        if (object instanceof DebuggableWithTitle) {
            DebuggableWithTitle d = (DebuggableWithTitle)object;
            debug.startSection(d.debugTitle());
            d.debugData(debug);
            debug.endSection();
        } else {
            debug.appendln("no debug for " + object);
        }
    }

    public void appendState(ToString asString) {
        asString.append("authenticationSession", (Object)this.getAuthenticationSession());
        asString.append("persistenceSession", (Object)this.getPersistenceSession());
        asString.append("transaction", (Object)this.getCurrentTransaction());
        if (this.getCurrentTransaction() != null) {
            asString.append("messageBroker", (Object)this.getCurrentTransaction().getMessageBroker());
            asString.append("updateNotifier", (Object)this.getCurrentTransaction().getUpdateNotifier());
        }
    }

    @Override
    public void debugState(DebugBuilder debug) {
        debug.appendln("authenticationSession", (Object)this.getAuthenticationSession());
        debug.appendln("persistenceSession", (Object)this.getPersistenceSession());
        debug.appendln("transaction", (Object)this.getCurrentTransaction());
        if (this.getCurrentTransaction() != null) {
            debug.appendln("messageBroker", (Object)this.getCurrentTransaction().getMessageBroker());
            debug.appendln("updateNotifier", (Object)this.getCurrentTransaction().getUpdateNotifier());
        }
    }

    private IsisTransactionManager getTransactionManager() {
        return this.getPersistenceSession().getTransactionManager();
    }
}

