/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.system.session;

import java.util.List;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.JavaClassUtils;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSession;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionDefault;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class IsisSessionFactoryAbstract
implements IsisSessionFactory {
    private final DeploymentType deploymentType;
    private final IsisConfiguration configuration;
    private final TemplateImageLoader templateImageLoader;
    private final SpecificationLoader specificationLoader;
    private final AuthenticationManager authenticationManager;
    private final AuthorizationManager authorizationManager;
    private final PersistenceSessionFactory persistenceSessionFactory;
    private final UserProfileLoader userProfileLoader;
    private final List<Object> serviceList;

    public IsisSessionFactoryAbstract(DeploymentType deploymentType, IsisConfiguration configuration, SpecificationLoader specificationLoader, TemplateImageLoader templateImageLoader, AuthenticationManager authenticationManager, AuthorizationManager authorizationManager, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory, List<Object> serviceList) {
        Ensure.ensureThatArg((Object)deploymentType, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)configuration, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)specificationLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)templateImageLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authenticationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)authorizationManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)userProfileLoader, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg((Object)persistenceSessionFactory, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        Ensure.ensureThatArg(serviceList, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.deploymentType = deploymentType;
        this.configuration = configuration;
        this.templateImageLoader = templateImageLoader;
        this.specificationLoader = specificationLoader;
        this.authenticationManager = authenticationManager;
        this.authorizationManager = authorizationManager;
        this.userProfileLoader = userProfileLoader;
        this.persistenceSessionFactory = persistenceSessionFactory;
        this.serviceList = serviceList;
    }

    public void init() {
        this.templateImageLoader.init();
        this.specificationLoader.setServiceClasses(JavaClassUtils.toClasses(this.serviceList));
        this.specificationLoader.init();
        this.specificationLoader.injectInto((Object)this.persistenceSessionFactory);
        this.persistenceSessionFactory.setServices(this.serviceList);
        this.userProfileLoader.setServices(this.serviceList);
        this.authenticationManager.init();
        this.authorizationManager.init();
        this.persistenceSessionFactory.init();
    }

    public void shutdown() {
        this.persistenceSessionFactory.shutdown();
        this.authenticationManager.shutdown();
        this.specificationLoader.shutdown();
        this.templateImageLoader.shutdown();
        this.userProfileLoader.shutdown();
    }

    @Override
    public IsisSession openSession(AuthenticationSession authenticationSession) {
        PersistenceSession persistenceSession = this.persistenceSessionFactory.createPersistenceSession();
        Ensure.ensureThatArg((Object)persistenceSession, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        UserProfile userProfile = this.userProfileLoader.getProfile(authenticationSession);
        Ensure.ensureThatArg((Object)userProfile, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.getSpecificationLoader().injectInto((Object)persistenceSession);
        IsisSessionDefault isisSessionDefault = new IsisSessionDefault(this, authenticationSession, persistenceSession, userProfile);
        return isisSessionDefault;
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.configuration;
    }

    @Override
    public DeploymentType getDeploymentType() {
        return this.deploymentType;
    }

    @Override
    public SpecificationLoader getSpecificationLoader() {
        return this.specificationLoader;
    }

    @Override
    public TemplateImageLoader getTemplateImageLoader() {
        return this.templateImageLoader;
    }

    @Override
    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    @Override
    public AuthorizationManager getAuthorizationManager() {
        return this.authorizationManager;
    }

    @Override
    public PersistenceSessionFactory getPersistenceSessionFactory() {
        return this.persistenceSessionFactory;
    }

    @Override
    public UserProfileLoader getUserProfileLoader() {
        return this.userProfileLoader;
    }

    @Override
    public List<Object> getServices() {
        return this.serviceList;
    }
}

