/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.systemusinginstallers;

import org.apache.isis.applib.fixtures.LogonFixture;
import org.apache.isis.core.commons.authentication.AuthenticationSession;
import org.apache.isis.core.commons.components.Noop;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.runtimes.dflt.runtime.fixtures.FixturesInstaller;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.IsisSystemException;
import org.apache.isis.runtimes.dflt.runtime.system.IsisSystemFixturesHookAbstract;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.internal.InitialisationSession;
import org.apache.isis.runtimes.dflt.runtime.system.internal.IsisLocaleInitializer;
import org.apache.isis.runtimes.dflt.runtime.system.internal.IsisTimeZoneInitializer;
import org.apache.log4j.Logger;

public abstract class IsisSystemAbstract
extends IsisSystemFixturesHookAbstract {
    public static final Logger LOG = Logger.getLogger(IsisSystemAbstract.class);
    private FixturesInstaller fixtureInstaller;
    private LogonFixture logonFixture;

    public IsisSystemAbstract(DeploymentType deploymentType) {
        super(deploymentType, new IsisLocaleInitializer(), new IsisTimeZoneInitializer());
    }

    public IsisSystemAbstract(DeploymentType deploymentType, IsisLocaleInitializer localeInitializer, IsisTimeZoneInitializer timeZoneInitializer) {
        super(deploymentType, localeInitializer, timeZoneInitializer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void installFixturesIfRequired() throws IsisSystemException {
        if (!this.getDeploymentType().canInstallFixtures()) {
            return;
        }
        this.fixtureInstaller = this.obtainFixturesInstaller();
        if (this.isNoop(this.fixtureInstaller)) {
            return;
        }
        IsisContext.openSession((AuthenticationSession)new InitialisationSession());
        this.fixtureInstaller.installFixtures();
        try {
            if (!this.getDeploymentType().isProduction()) {
                this.logonFixture = this.fixtureInstaller.getLogonFixture();
            }
        }
        finally {
            IsisContext.closeSession();
        }
    }

    private boolean isNoop(FixturesInstaller candidate) {
        return candidate == null || this.fixtureInstaller instanceof Noop;
    }

    protected abstract FixturesInstaller obtainFixturesInstaller() throws IsisSystemException;

    public FixturesInstaller getFixturesInstaller() {
        return this.fixtureInstaller;
    }

    @Override
    public LogonFixture getLogonFixture() {
        return this.logonFixture;
    }

    @Override
    protected void appendFixturesInstallerDebug(DebugBuilder debug) {
        debug.appendln("Fixture Installer", (Object)(this.fixtureInstaller == null ? "none" : this.fixtureInstaller.getClass().getName()));
    }
}

