/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.systemusinginstallers;

import java.util.List;
import org.apache.isis.core.commons.config.IsisConfiguration;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.metamodel.runtimecontext.RuntimeContext;
import org.apache.isis.core.metamodel.spec.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.FacetDecoratorInstaller;
import org.apache.isis.core.metamodel.specloader.ObjectReflector;
import org.apache.isis.core.metamodel.specloader.ObjectReflectorInstaller;
import org.apache.isis.core.runtime.authentication.AuthenticationManager;
import org.apache.isis.core.runtime.authentication.AuthenticationManagerInstaller;
import org.apache.isis.core.runtime.authorization.AuthorizationManager;
import org.apache.isis.core.runtime.authorization.AuthorizationManagerInstaller;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoader;
import org.apache.isis.core.runtime.imageloader.TemplateImageLoaderInstaller;
import org.apache.isis.core.runtime.userprofile.UserProfileLoader;
import org.apache.isis.core.runtime.userprofile.UserProfileStore;
import org.apache.isis.runtimes.dflt.runtime.fixtures.FixturesInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.InstallerLookup;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.ClientConnectionInstaller;
import org.apache.isis.runtimes.dflt.runtime.installerregistry.installerapi.PersistenceMechanismInstaller;
import org.apache.isis.runtimes.dflt.runtime.persistence.internal.RuntimeContextFromSession;
import org.apache.isis.runtimes.dflt.runtime.services.ServicesInstaller;
import org.apache.isis.runtimes.dflt.runtime.system.DeploymentType;
import org.apache.isis.runtimes.dflt.runtime.system.IsisSystemException;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactory;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSessionFactoryDefault;
import org.apache.isis.runtimes.dflt.runtime.systemdependencyinjector.SystemDependencyInjector;
import org.apache.isis.runtimes.dflt.runtime.systemusinginstallers.IsisSystemAbstract;
import org.apache.isis.runtimes.dflt.runtime.transaction.facetdecorator.standard.TransactionFacetDecoratorInstaller;
import org.apache.isis.runtimes.dflt.runtime.userprofile.UserProfileLoaderDefault;
import org.apache.isis.runtimes.dflt.runtime.userprofile.UserProfileStoreInstaller;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class IsisSystemUsingInstallers
extends IsisSystemAbstract {
    public static final Logger LOG = Logger.getLogger(IsisSystemUsingInstallers.class);
    private final InstallerLookup installerLookup;
    private AuthenticationManagerInstaller authenticationInstaller;
    private AuthorizationManagerInstaller authorizationInstaller;
    private ObjectReflectorInstaller reflectorInstaller;
    private ServicesInstaller servicesInstaller;
    private UserProfileStoreInstaller userProfileStoreInstaller;
    private PersistenceMechanismInstaller persistenceMechanismInstaller;
    private FixturesInstaller fixtureInstaller;

    public IsisSystemUsingInstallers(DeploymentType deploymentType, InstallerLookup installerLookup) {
        super(deploymentType);
        Ensure.ensureThatArg((Object)installerLookup, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())));
        this.installerLookup = installerLookup;
    }

    public SystemDependencyInjector getInstallerLookup() {
        return this.installerLookup;
    }

    @Override
    public IsisSessionFactory doCreateSessionFactory(DeploymentType deploymentType) throws IsisSystemException {
        PersistenceSessionFactory persistenceSessionFactory = this.obtainPersistenceSessionFactory(deploymentType);
        UserProfileLoaderDefault userProfileLoader = new UserProfileLoaderDefault(this.obtainUserProfileStore());
        return this.createSessionFactory(deploymentType, userProfileLoader, persistenceSessionFactory);
    }

    protected final IsisSessionFactory createSessionFactory(DeploymentType deploymentType, UserProfileLoader userProfileLoader, PersistenceSessionFactory persistenceSessionFactory) throws IsisSystemException {
        IsisConfiguration configuration = this.getConfiguration();
        AuthenticationManager authenticationManager = this.obtainAuthenticationManager(deploymentType);
        AuthorizationManager authorizationManager = this.obtainAuthorizationManager(deploymentType);
        TemplateImageLoader templateImageLoader = this.obtainTemplateImageLoader();
        ObjectReflector reflector = this.obtainReflector(deploymentType);
        List<Object> servicesList = this.obtainServices();
        reflector.setRuntimeContext((RuntimeContext)new RuntimeContextFromSession());
        return new IsisSessionFactoryDefault(deploymentType, configuration, templateImageLoader, (SpecificationLoader)reflector, authenticationManager, authorizationManager, userProfileLoader, persistenceSessionFactory, servicesList);
    }

    @Override
    public IsisConfiguration getConfiguration() {
        return this.installerLookup.getConfiguration();
    }

    public void lookupAndSetAuthenticatorAndAuthorization(DeploymentType deploymentType) {
        IsisConfiguration configuration = this.installerLookup.getConfiguration();
        String connection = configuration.getString("isis.connector");
        if (connection != null) {
            this.lookupAndSetAuthenticatorAndAuthorizationUsingClientConnectionInstaller(connection);
        } else {
            this.lookupAndSetAuthenticatorAndAuthorizationInstallers(deploymentType);
        }
    }

    private void lookupAndSetAuthenticatorAndAuthorizationUsingClientConnectionInstaller(String connection) {
        ClientConnectionInstaller clientConnectionInstaller = this.installerLookup.clientConnectionInstaller(connection);
        if (clientConnectionInstaller == null) {
            return;
        }
        this.setAuthenticationInstaller(clientConnectionInstaller);
        this.setAuthorizationInstaller(clientConnectionInstaller);
    }

    private void lookupAndSetAuthenticatorAndAuthorizationInstallers(DeploymentType deploymentType) {
        String authorizationManagerKey;
        AuthorizationManagerInstaller authorizationInstaller;
        String authenticationManagerKey = this.getConfiguration().getString("isis.authentication");
        AuthenticationManagerInstaller authenticationInstaller = this.installerLookup.authenticationManagerInstaller(authenticationManagerKey, deploymentType);
        if (authenticationInstaller != null) {
            this.setAuthenticationInstaller(authenticationInstaller);
        }
        if ((authorizationInstaller = this.installerLookup.authorizationManagerInstaller(authorizationManagerKey = this.getConfiguration().getString("isis.authorization"), deploymentType)) != null) {
            this.setAuthorizationInstaller(authorizationInstaller);
        }
    }

    public void setAuthenticationInstaller(AuthenticationManagerInstaller authenticationManagerInstaller) {
        this.authenticationInstaller = authenticationManagerInstaller;
    }

    public void setAuthorizationInstaller(AuthorizationManagerInstaller authorizationManagerInstaller) {
        this.authorizationInstaller = authorizationManagerInstaller;
    }

    @Override
    protected AuthenticationManager obtainAuthenticationManager(DeploymentType deploymentType) {
        return this.authenticationInstaller.createAuthenticationManager();
    }

    protected AuthorizationManager obtainAuthorizationManager(DeploymentType deploymentType) {
        return this.authorizationInstaller.createAuthorizationManager();
    }

    public void lookupAndSetFixturesInstaller() {
        IsisConfiguration configuration = this.installerLookup.getConfiguration();
        String fixture = configuration.getString("isis.fixtures-installer");
        FixturesInstaller fixturesInstaller = this.installerLookup.fixturesInstaller(fixture);
        if (fixturesInstaller != null) {
            this.fixtureInstaller = fixturesInstaller;
        }
    }

    public void setFixtureInstaller(FixturesInstaller fixtureInstaller) {
        this.fixtureInstaller = fixtureInstaller;
    }

    @Override
    protected FixturesInstaller obtainFixturesInstaller() throws IsisSystemException {
        return this.fixtureInstaller;
    }

    @Override
    protected TemplateImageLoader obtainTemplateImageLoader() {
        TemplateImageLoaderInstaller templateImageLoaderInstaller = this.installerLookup.templateImageLoaderInstaller(null);
        if (templateImageLoaderInstaller != null) {
            return templateImageLoaderInstaller.createLoader();
        }
        return super.obtainTemplateImageLoader();
    }

    public void setReflectorInstaller(ObjectReflectorInstaller reflectorInstaller) {
        this.reflectorInstaller = reflectorInstaller;
    }

    @Override
    protected ObjectReflector obtainReflector(DeploymentType deploymentType) throws IsisSystemException {
        if (this.reflectorInstaller == null) {
            String fromCmdLine = this.getConfiguration().getString("isis.reflector");
            this.reflectorInstaller = this.installerLookup.reflectorInstaller(fromCmdLine);
        }
        Ensure.ensureThatState((Object)this.reflectorInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"reflector installer has not been injected and could not be looked up");
        this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)this.installerLookup.getInstaller(TransactionFacetDecoratorInstaller.class));
        String connection = this.getConfiguration().getString("isis.connector");
        if (connection != null) {
            ClientConnectionInstaller clientConnectionInstaller = this.installerLookup.clientConnectionInstaller(connection);
            this.reflectorInstaller.addFacetDecoratorInstaller((FacetDecoratorInstaller)clientConnectionInstaller);
        }
        return this.reflectorInstaller.createReflector();
    }

    public void setServicesInstaller(ServicesInstaller servicesInstaller) {
        this.servicesInstaller = servicesInstaller;
    }

    @Override
    protected List<Object> obtainServices() {
        if (this.servicesInstaller == null) {
            this.servicesInstaller = this.installerLookup.servicesInstaller(null);
        }
        Ensure.ensureThatState((Object)this.servicesInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"services installer has not been injected and could not be looked up");
        return this.servicesInstaller.getServices(this.getDeploymentType());
    }

    public void lookupAndSetUserProfileFactoryInstaller() {
        IsisConfiguration configuration = this.installerLookup.getConfiguration();
        String persistor = configuration.getString("isis.user-profile-store");
        UserProfileStoreInstaller userProfilePersistenceMechanismInstaller = this.installerLookup.userProfilePersistenceMechanismInstaller(persistor, this.getDeploymentType());
        if (userProfilePersistenceMechanismInstaller != null) {
            this.setUserProfileStoreInstaller(userProfilePersistenceMechanismInstaller);
        }
    }

    public void setUserProfileStoreInstaller(UserProfileStoreInstaller userProfilestoreInstaller) {
        this.userProfileStoreInstaller = userProfilestoreInstaller;
    }

    @Override
    protected UserProfileStore obtainUserProfileStore() {
        return this.userProfileStoreInstaller.createUserProfileStore(this.getConfiguration());
    }

    public void setPersistenceMechanismInstaller(PersistenceMechanismInstaller persistenceMechanismInstaller) {
        this.persistenceMechanismInstaller = persistenceMechanismInstaller;
    }

    @Override
    protected PersistenceSessionFactory obtainPersistenceSessionFactory(DeploymentType deploymentType) throws IsisSystemException {
        String connection = this.getConfiguration().getString("isis.connector");
        if (connection != null) {
            this.persistenceMechanismInstaller = this.installerLookup.clientConnectionInstaller(connection);
        }
        if (this.persistenceMechanismInstaller == null) {
            String persistenceMechanism = this.getConfiguration().getString("isis.persistor");
            this.persistenceMechanismInstaller = this.installerLookup.persistenceMechanismInstaller(persistenceMechanism, deploymentType);
        }
        Ensure.ensureThatState((Object)this.persistenceMechanismInstaller, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"persistor installer has not been injected and could not be looked up");
        return this.persistenceMechanismInstaller.createPersistenceSessionFactory(deploymentType);
    }
}

