/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction;

import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransaction;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class IsisTransactionAbstract
implements IsisTransaction {
    private static final Logger LOG = Logger.getLogger(IsisTransactionAbstract.class);
    private final IsisTransactionManager transactionManager;
    private final MessageBroker messageBroker;
    private final UpdateNotifier updateNotifier;
    private IsisTransaction.State state;
    private RuntimeException cause;

    public IsisTransactionAbstract(IsisTransactionManager transactionManager, MessageBroker messageBroker, UpdateNotifier updateNotifier) {
        Ensure.ensureThatArg((Object)transactionManager, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"transaction manager is required");
        Ensure.ensureThatArg((Object)messageBroker, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"message broker is required");
        Ensure.ensureThatArg((Object)updateNotifier, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Matcher)CoreMatchers.nullValue())), (String)"update notifier is required");
        this.transactionManager = transactionManager;
        this.messageBroker = messageBroker;
        this.updateNotifier = updateNotifier;
        this.state = IsisTransaction.State.IN_PROGRESS;
    }

    @Override
    public IsisTransaction.State getState() {
        return this.state;
    }

    private void setState(IsisTransaction.State state) {
        this.state = state;
    }

    public final void flush() {
        Ensure.ensureThatState((Object)this.getState().canFlush(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("flush transaction " + this));
        }
        try {
            this.doFlush();
        }
        catch (RuntimeException ex) {
            this.setState(IsisTransaction.State.MUST_ABORT);
            this.setAbortCause(ex);
            throw ex;
        }
    }

    public final void commit() {
        Ensure.ensureThatState((Object)this.getState().canCommit(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("commit transaction " + this));
        }
        if (this.getState() == IsisTransaction.State.COMMITTED) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"already committed; ignoring");
            }
            return;
        }
        try {
            this.doFlush();
            this.setState(IsisTransaction.State.COMMITTED);
        }
        catch (RuntimeException ex) {
            this.setAbortCause(ex);
            throw ex;
        }
    }

    public final void abort() {
        Ensure.ensureThatState((Object)this.getState().canAbort(), (Matcher)CoreMatchers.is((Object)true), (String)("state is: " + (Object)((Object)this.getState())));
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("abort transaction " + this));
        }
        try {
            this.doAbort();
        }
        catch (RuntimeException ex) {
            this.setAbortCause(ex);
            throw ex;
        }
        finally {
            this.setState(IsisTransaction.State.ABORTED);
        }
    }

    protected abstract void doFlush();

    protected abstract void doAbort();

    protected void setAbortCause(RuntimeException cause) {
        this.cause = cause;
    }

    @Override
    public RuntimeException getAbortCause() {
        return this.cause;
    }

    public String toString() {
        return this.appendTo(new ToString((Object)this)).toString();
    }

    protected ToString appendTo(ToString str) {
        str.append("state", (Object)this.state);
        return str;
    }

    @Override
    public IsisTransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public MessageBroker getMessageBroker() {
        return this.messageBroker;
    }

    @Override
    public UpdateNotifier getUpdateNotifier() {
        return this.updateNotifier;
    }
}

