/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction;

import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.ensure.Ensure;
import org.apache.isis.runtimes.dflt.runtime.system.session.IsisSession;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransaction;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManagerAware;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.TransactionalClosure;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.TransactionalClosureWithReturn;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.UpdateNotifier;
import org.apache.isis.runtimes.dflt.runtime.transaction.IsisTransactionManagerException;
import org.apache.isis.runtimes.dflt.runtime.transaction.messagebroker.MessageBrokerDefault;
import org.apache.isis.runtimes.dflt.runtime.transaction.updatenotifier.UpdateNotifierDefault;
import org.apache.log4j.Logger;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public abstract class IsisTransactionManagerAbstract<T extends IsisTransaction>
implements IsisTransactionManager {
    private static final Logger LOG = Logger.getLogger(IsisTransactionManagerAbstract.class);
    private IsisSession session;
    private T transaction;

    public void open() {
        Ensure.ensureThatState((Object)this.session, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.notNullValue()), (String)"session is required");
    }

    public void close() {
        if (this.getTransaction() != null) {
            try {
                this.abortTransaction();
            }
            catch (Exception e2) {
                LOG.error((Object)"failure during abort", (Throwable)e2);
            }
        }
        this.session = null;
    }

    public T getTransaction() {
        return this.transaction;
    }

    protected UpdateNotifier getUpdateNotifier() {
        return this.getTransaction().getUpdateNotifier();
    }

    protected MessageBroker getMessageBroker() {
        return this.getTransaction().getMessageBroker();
    }

    @Override
    public void executeWithinTransaction(TransactionalClosure closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                try {
                    this.abortTransaction();
                }
                catch (Exception e) {
                    LOG.error((Object)"Abort failure after exception", (Throwable)e);
                    throw new IsisTransactionManagerException("Abort failure: " + e.getMessage(), ex);
                }
            }
            throw ex;
        }
    }

    public <Q> Q executeWithinTransaction(TransactionalClosureWithReturn<Q> closure) {
        boolean initiallyInTransaction = this.inTransaction();
        if (!initiallyInTransaction) {
            this.startTransaction();
        }
        try {
            closure.preExecute();
            Q retVal = closure.execute();
            closure.onSuccess();
            if (!initiallyInTransaction) {
                this.endTransaction();
            }
            return retVal;
        }
        catch (RuntimeException ex) {
            closure.onFailure();
            if (!initiallyInTransaction) {
                this.abortTransaction();
            }
            throw ex;
        }
    }

    public boolean inTransaction() {
        return this.getTransaction() != null && !this.getTransaction().getState().isComplete();
    }

    protected final T createTransaction() {
        this.transaction = this.createTransaction(this.createMessageBroker(), this.createUpdateNotifier());
        return this.transaction;
    }

    protected abstract T createTransaction(MessageBroker var1, UpdateNotifier var2);

    protected MessageBroker createMessageBroker() {
        return new MessageBrokerDefault();
    }

    protected UpdateNotifier createUpdateNotifier() {
        return new UpdateNotifierDefault();
    }

    protected void ensureTransactionInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)true), (String)"No transaction in progress");
    }

    protected void ensureTransactionNotInProgress() {
        Ensure.ensureThatState((Object)(this.getTransaction() != null && !this.getTransaction().getState().isComplete() ? 1 : 0), (Matcher)CoreMatchers.is((Object)false), (String)"Transaction in progress");
    }

    public void injectInto(Object candidate) {
        if (IsisTransactionManagerAware.class.isAssignableFrom(candidate.getClass())) {
            IsisTransactionManagerAware cast = (IsisTransactionManagerAware)IsisTransactionManagerAware.class.cast(candidate);
            cast.setTransactionManager(this);
        }
    }

    @Override
    public void debugData(DebugBuilder debug) {
        debug.appendln("Transaction", this.getTransaction());
    }

    @Override
    public IsisSession getSession() {
        return this.session;
    }

    public void setSession(IsisSession session) {
        this.session = session;
    }
}

