/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction.facets;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertyClearFacetAbstract;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.transaction.TransactionalClosureAbstract;

public class PropertyClearFacetWrapTransaction
extends PropertyClearFacetAbstract
implements DecoratingFacet<PropertyClearFacet> {
    private final PropertyClearFacet underlyingFacet;

    public PropertyClearFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public PropertyClearFacetWrapTransaction(PropertyClearFacet underlyingFacet) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
    }

    public void clearProperty(final ObjectAdapter adapter) {
        if (adapter.isTransient()) {
            this.underlyingFacet.clearProperty(adapter);
        } else {
            PropertyClearFacetWrapTransaction.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

                @Override
                public void execute() {
                    PropertyClearFacetWrapTransaction.this.underlyingFacet.clearProperty(adapter);
                }
            });
        }
    }

    public String toString() {
        return super.toString() + " --> " + this.underlyingFacet.toString();
    }

    private static IsisTransactionManager getTransactionManager() {
        return PropertyClearFacetWrapTransaction.getPersistenceSession().getTransactionManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

