/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction.facets;

import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.facetapi.DecoratingFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacet;
import org.apache.isis.core.metamodel.facets.properties.modify.PropertySetterFacetAbstract;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.IsisTransactionManager;
import org.apache.isis.runtimes.dflt.runtime.transaction.TransactionalClosureAbstract;

public class PropertySetterFacetWrapTransaction
extends PropertySetterFacetAbstract
implements DecoratingFacet<PropertySetterFacet> {
    private final PropertySetterFacet underlyingFacet;

    public PropertySetterFacetWrapTransaction(PropertySetterFacet underlyingFacet) {
        super(underlyingFacet.getFacetHolder());
        this.underlyingFacet = underlyingFacet;
    }

    public PropertySetterFacet getDecoratedFacet() {
        return this.underlyingFacet;
    }

    public void setProperty(final ObjectAdapter adapter, final ObjectAdapter referencedAdapter) {
        if (adapter.isTransient()) {
            this.underlyingFacet.setProperty(adapter, referencedAdapter);
        } else {
            PropertySetterFacetWrapTransaction.getTransactionManager().executeWithinTransaction(new TransactionalClosureAbstract(){

                @Override
                public void execute() {
                    PropertySetterFacetWrapTransaction.this.underlyingFacet.setProperty(adapter, referencedAdapter);
                }
            });
        }
    }

    public String toString() {
        return super.toString() + " --> " + this.underlyingFacet.toString();
    }

    private static IsisTransactionManager getTransactionManager() {
        return PropertySetterFacetWrapTransaction.getPersistenceSession().getTransactionManager();
    }

    private static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

