/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction.messagebroker;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.StringUtils;
import org.apache.isis.runtimes.dflt.runtime.system.transaction.MessageBroker;

public class MessageBrokerDefault
implements MessageBroker,
DebuggableWithTitle {
    private final List<String> messages = new ArrayList<String>();
    private final List<String> warnings = new ArrayList<String>();

    public void reset() {
        this.warnings.clear();
        this.messages.clear();
    }

    @Override
    public void ensureEmpty() {
        if (this.warnings.size() > 0) {
            throw new IsisException("Message broker still has warnings");
        }
        if (this.messages.size() > 0) {
            throw new IsisException("Message broker still has messages");
        }
    }

    @Override
    public List<String> getMessages() {
        return this.copyAndClear(this.messages);
    }

    @Override
    public void addMessage(String message) {
        this.messages.add(message);
    }

    @Override
    public String getMessagesCombined() {
        List<String> x = this.messages;
        String string = StringUtils.combine(x);
        return string;
    }

    @Override
    public List<String> getWarnings() {
        return this.copyAndClear(this.warnings);
    }

    @Override
    public void addWarning(String message) {
        this.warnings.add(message);
    }

    @Override
    public String getWarningsCombined() {
        List<String> x = this.warnings;
        String string = StringUtils.combine(x);
        return string;
    }

    public void debugData(DebugBuilder debug) {
        this.debugArray(debug, "Messages", this.messages);
        this.debugArray(debug, "Warnings", this.messages);
    }

    private void debugArray(DebugBuilder debug, String title, List<String> vector) {
        debug.appendln(title);
        debug.indent();
        if (vector.size() == 0) {
            debug.appendln("none");
        } else {
            for (String text : vector) {
                debug.appendln(text);
            }
        }
        debug.unindent();
    }

    public String debugTitle() {
        return "Simple Message Broker";
    }

    private List<String> copyAndClear(List<String> messages) {
        List<String> copy = Collections.unmodifiableList(new ArrayList<String>(messages));
        messages.clear();
        return copy;
    }
}

