/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.transaction.updatenotifier;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.commons.exceptions.IsisException;
import org.apache.isis.core.commons.lang.ToString;
import org.apache.isis.core.metamodel.adapter.ObjectAdapter;
import org.apache.isis.core.metamodel.adapter.ResolveState;
import org.apache.isis.runtimes.dflt.runtime.transaction.updatenotifier.UpdateNotifierAbstract;
import org.apache.log4j.Logger;

public class UpdateNotifierDefault
extends UpdateNotifierAbstract
implements DebuggableWithTitle {
    private static final Logger LOG = Logger.getLogger(UpdateNotifierDefault.class);
    private final List<ObjectAdapter> changes = new ArrayList<ObjectAdapter>();
    private final List<ObjectAdapter> disposals = new ArrayList<ObjectAdapter>();

    @Override
    public synchronized void addChangedObject(ObjectAdapter adapter) {
        ResolveState resolveState = adapter.getResolveState();
        if (!resolveState.isResolved() && !adapter.isTransient()) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mark as changed " + adapter));
        }
        if (!this.changes.contains(adapter)) {
            this.changes.add(adapter);
        }
    }

    @Override
    public List<ObjectAdapter> getChangedObjects() {
        if (this.changes.size() > 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("dirty (changed) objects " + this.changes));
        }
        ArrayList<ObjectAdapter> changedObjects = new ArrayList<ObjectAdapter>();
        changedObjects.addAll(this.changes);
        this.changes.clear();
        return Collections.unmodifiableList(changedObjects);
    }

    @Override
    public void addDisposedObject(ObjectAdapter adapter) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("mark as disposed " + adapter));
        }
        if (!this.disposals.contains(adapter)) {
            this.disposals.add(adapter);
        }
    }

    @Override
    public List<ObjectAdapter> getDisposedObjects() {
        if (this.disposals.size() > 0 && LOG.isDebugEnabled()) {
            LOG.debug((Object)("dirty (disposed) objects " + this.disposals));
        }
        ArrayList<ObjectAdapter> disposedObjects = new ArrayList<ObjectAdapter>();
        disposedObjects.addAll(this.disposals);
        this.disposals.clear();
        return Collections.unmodifiableList(disposedObjects);
    }

    @Override
    public void ensureEmpty() {
        if (this.changes.size() > 0) {
            throw new IsisException("Update notifier still has updates");
        }
    }

    @Override
    public void clear() {
        this.changes.clear();
        this.disposals.clear();
    }

    public void debugData(DebugBuilder debug) {
        debug.appendln("Changes");
        this.debugList(debug, this.changes);
        debug.appendln("Disposals");
        this.debugList(debug, this.disposals);
    }

    public String debugTitle() {
        return "Simple Update Notifier";
    }

    private void debugList(DebugBuilder debug, List<ObjectAdapter> list) {
        debug.indent();
        if (list.size() == 0) {
            debug.appendln("none");
        } else {
            for (ObjectAdapter adapter : list) {
                debug.appendln(adapter.toString());
            }
        }
        debug.unindent();
    }

    public String toString() {
        return new ToString((Object)this).append("changes", this.changes).toString();
    }
}

