/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.runtimes.dflt.runtime.userprofile;

import org.apache.isis.core.commons.debug.DebugBuilder;
import org.apache.isis.core.commons.debug.DebuggableWithTitle;
import org.apache.isis.core.metamodel.adapter.map.AdapterMap;
import org.apache.isis.core.metamodel.services.ServiceUtil;
import org.apache.isis.core.runtime.userprofile.PerspectiveEntry;
import org.apache.isis.core.runtime.userprofile.UserProfile;
import org.apache.isis.runtimes.dflt.runtime.system.context.IsisContext;
import org.apache.isis.runtimes.dflt.runtime.system.persistence.PersistenceSession;

public final class UserProfilesDebugUtil {
    public static DebuggableWithTitle asDebuggableWithTitle(final UserProfile userProfile) {
        return new DebuggableWithTitle(){

            public void debugData(DebugBuilder debug) {
                debug.appendTitle("Options");
                debug.indent();
                debug.append((Object)userProfile.getOptions());
                debug.unindent();
                debug.appendTitle("Perspectives");
                for (PerspectiveEntry entry : userProfile.getEntries()) {
                    UserProfilesDebugUtil.asDebuggableWithTitle(entry).debugData(debug);
                }
            }

            public String debugTitle() {
                return this.toString();
            }
        };
    }

    public static DebuggableWithTitle asDebuggableWithTitle(final PerspectiveEntry perspectiveEntry) {
        return new DebuggableWithTitle(){

            public void debugData(DebugBuilder debug) {
                debug.appendln("Name", (Object)perspectiveEntry.getName());
                debug.blankLine();
                debug.appendTitle("Services (Ids)");
                debug.indent();
                for (Object service : perspectiveEntry.getServices()) {
                    debug.appendln(ServiceUtil.id(service));
                }
                debug.unindent();
                debug.blankLine();
                debug.appendTitle("Objects");
                debug.indent();
                AdapterMap adapterMap = UserProfilesDebugUtil.getAdapterMap();
                for (Object obj : perspectiveEntry.getObjects()) {
                    debug.appendln(adapterMap.adapterFor(obj).toString());
                }
                debug.unindent();
            }

            public String debugTitle() {
                return "Perspective";
            }
        };
    }

    private static AdapterMap getAdapterMap() {
        return UserProfilesDebugUtil.getPersistenceSession().getAdapterManager();
    }

    protected static PersistenceSession getPersistenceSession() {
        return IsisContext.getPersistenceSession();
    }
}

