/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import org.codehaus.plexus.util.StringUtils;

public class PlatformNameFormat {
    public static String getPlatformName(String repositoryName) {
        StringBuilder buf = new StringBuilder("_");
        boolean escapeColon = false;
        boolean useUnderscore = false;
        int numUnderscore = 0;
        block5: for (int i = 0; i < repositoryName.length(); ++i) {
            char c = repositoryName.charAt(i);
            switch (c) {
                case ':': {
                    if (!escapeColon && i > 0) {
                        escapeColon = true;
                        useUnderscore = true;
                        numUnderscore = 2;
                        buf.append('_');
                        continue block5;
                    }
                    buf.append("%3a");
                    continue block5;
                }
                case '_': {
                    if (i == 0) {
                        useUnderscore = true;
                    }
                    ++numUnderscore;
                    escapeColon = true;
                    buf.append(c);
                    continue block5;
                }
                case '\"': 
                case '%': 
                case '/': 
                case '<': 
                case '>': 
                case '?': 
                case '\\': 
                case '|': {
                    buf.append('%');
                    buf.append(Character.forDigit(c / 16, 16));
                    buf.append(Character.forDigit(c % 16, 16));
                    continue block5;
                }
                default: {
                    buf.append(c);
                }
            }
        }
        if (useUnderscore && numUnderscore > 1) {
            return buf.toString();
        }
        return buf.substring(1);
    }

    public static String getPlatformPath(String repoPath) {
        Object[] elems = StringUtils.split((String)repoPath, (String)"/");
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].length() <= 0) continue;
            elems[i] = PlatformNameFormat.getPlatformName((String)elems[i]);
        }
        return StringUtils.join((Object[])elems, (String)"/");
    }

    public static String getRepositoryName(String platformName) {
        StringBuilder buffer = new StringBuilder("_");
        boolean firstUnderscore = false;
        for (int i = 0; i < platformName.length(); ++i) {
            char c = platformName.charAt(i);
            if (c == '%') {
                if (platformName.length() > i + 2) {
                    int a = Character.digit(platformName.charAt(++i), 16);
                    int b = Character.digit(platformName.charAt(++i), 16);
                    c = (char)(a * 16 + b);
                }
            } else if (c == '_') {
                if (i == 0) {
                    firstUnderscore = true;
                    if (platformName.length() <= 1) continue;
                    if ((c = (char)platformName.charAt(++i)) == '_') {
                        buffer.append('_');
                        firstUnderscore = false;
                        continue;
                    }
                    buffer.append(c);
                    continue;
                }
                if (firstUnderscore) {
                    c = ':';
                    firstUnderscore = false;
                }
            }
            buffer.append(c);
        }
        if (firstUnderscore) {
            return buffer.toString();
        }
        return buffer.substring(1);
    }

    public static String getRepositoryPath(String path) {
        Object[] elems = StringUtils.split((String)path, (String)"/");
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].length() <= 0) continue;
            elems[i] = PlatformNameFormat.getRepositoryName((String)elems[i]);
        }
        return StringUtils.join((Object[])elems, (String)"/");
    }

    public static String getRepositoryPath(String path, boolean respectDotDir) {
        Object[] elems = StringUtils.split((String)path, (String)"/");
        for (int i = 0; i < elems.length; ++i) {
            if (elems[i].length() <= 0) continue;
            elems[i] = respectDotDir && ((String)elems[i]).endsWith(".dir") ? PlatformNameFormat.getRepositoryName(((String)elems[i]).substring(0, ((String)elems[i]).length() - 4)) : PlatformNameFormat.getRepositoryName((String)elems[i]);
        }
        return StringUtils.join((Object[])elems, (String)"/");
    }
}

