/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging.impl;

import java.util.List;
import org.apache.jackrabbit.filevault.maven.packaging.impl.FilterSet;
import org.apache.jackrabbit.filevault.maven.packaging.impl.StringFilter;

public class StringFilterSet
extends FilterSet<StringFilter> {
    public void addEntry(String pattern) {
        if (pattern.startsWith("~")) {
            this.addExclude(new StringFilter(pattern.substring(1)));
        } else {
            this.addInclude(new StringFilter(pattern));
        }
    }

    public void addEntries(String patterns) {
        for (String name : patterns.split(",")) {
            this.addEntry(name.trim());
        }
    }

    public boolean contains(String path) {
        List entries = this.getEntries();
        if (entries.isEmpty()) {
            return true;
        }
        boolean result = !entries.get(0).isInclude();
        for (FilterSet.Entry entry : entries) {
            if (!((StringFilter)entry.getFilter()).matches(path)) continue;
            result = entry.isInclude();
        }
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        String delim = "";
        for (FilterSet.Entry entry : this.getEntries()) {
            builder.append(delim);
            if (!entry.isInclude()) {
                builder.append("~");
            }
            builder.append(entry.getFilter());
            delim = ",";
        }
        return builder.toString();
    }
}

