/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.filevault.maven.packaging;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.jackrabbit.filevault.maven.packaging.Filters;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

public abstract class AbstractMetadataPackageMojo
extends AbstractMojo {
    private static final String PROPERTIES_EMBEDDEDFILESMAP_KEY = "embeddedfiles.map";
    @Parameter(property="project", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(property="vault.metaInfVaultDirectory", required=true, defaultValue="${project.basedir}/META-INF/vault,${project.basedir}/src/main/META-INF/vault,${project.basedir}/src/main/content/META-INF/vault,${project.basedir}/src/content/META-INF/vault")
    File[] metaInfVaultDirectory;
    @Parameter(defaultValue="${project.build.directory}/vault-work", required=true)
    File workDirectory;
    @Parameter(property="vault.prefix", defaultValue="")
    String prefix = "";
    @Parameter(defaultValue="${project.build.outputTimestamp}")
    protected String outputTimestamp;

    protected static File getFirstExistingDirectory(File[] directories) {
        for (File dir : directories) {
            if (!dir.exists() || !dir.isDirectory()) continue;
            return dir;
        }
        return null;
    }

    public void setPrefix(String prefix) {
        if (prefix.startsWith("/")) {
            throw new IllegalArgumentException("Parameter 'prefix' must start with a slash!");
        }
        if (prefix.length() > 0 && !prefix.endsWith("/")) {
            prefix = prefix + "/";
        }
        this.prefix = prefix;
    }

    void setEmbeddedFilesMap(Map<String, File> embeddedFiles) {
        this.getPluginContext().put(PROPERTIES_EMBEDDEDFILESMAP_KEY, embeddedFiles);
    }

    Map<String, File> getEmbeddedFilesMap() {
        Object value = this.getPluginContext().get(PROPERTIES_EMBEDDEDFILESMAP_KEY);
        if (value == null) {
            return Collections.emptyMap();
        }
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new IllegalStateException("The Maven property embeddedfiles.map is not containing a Map but rather " + value.getClass());
    }

    File getGeneratedVaultDir() {
        return new File(this.workDirectory, "META-INF/vault");
    }

    File getGeneratedManifestFile() {
        return new File(this.workDirectory, "META-INF/MANIFEST.MF");
    }

    File getGeneratedFilterFile() {
        return new File(this.getGeneratedVaultDir(), "filter.xml");
    }

    protected File getMetaInfVaultSourceDirectory() {
        return AbstractMetadataPackageMojo.getMetaInfVaultSourceDirectory(this.metaInfVaultDirectory, this.getLog());
    }

    protected static File getMetaInfVaultSourceDirectory(File[] metaInfVaultDirectory, Log log) {
        File metaInfDirectory = AbstractMetadataPackageMojo.getFirstExistingDirectory(metaInfVaultDirectory);
        if (metaInfDirectory != null) {
            log.info((CharSequence)("Using META-INF/vault from " + metaInfDirectory.getPath()));
        }
        return metaInfDirectory;
    }

    Filters loadGeneratedFilterFile() throws IOException, ConfigurationException {
        Filters filters = new Filters();
        filters.load(this.getGeneratedFilterFile());
        return filters;
    }
}

