/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.jcr.Credentials;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import org.apache.jackrabbit.commons.DefaultContentHandler;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public abstract class AbstractSession
implements Session {
    public void exportDocumentView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getExportContentHandler(out);
            this.exportDocumentView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing document view XML", (Throwable)e);
        }
    }

    public void exportSystemView(String absPath, OutputStream out, boolean skipBinary, boolean noRecurse) throws IOException, RepositoryException {
        try {
            ContentHandler handler = this.getExportContentHandler(out);
            this.exportSystemView(absPath, handler, skipBinary, noRecurse);
        }
        catch (SAXException e) {
            Exception exception = e.getException();
            if (exception instanceof RepositoryException) {
                throw (RepositoryException)((Object)exception);
            }
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            throw new RepositoryException("Error serializing system view XML", (Throwable)e);
        }
    }

    public void importXML(String parentAbsPath, InputStream in, int uuidBehavior) throws IOException, RepositoryException {
        ContentHandler handler = this.getImportContentHandler(parentAbsPath, uuidBehavior);
        new DefaultContentHandler(handler).parse(in);
    }

    public Item getItem(String absPath) throws PathNotFoundException, RepositoryException {
        if (!absPath.startsWith("/")) {
            throw new PathNotFoundException("Not an absolute path: " + absPath);
        }
        Node root = this.getRootNode();
        String relPath = absPath.substring(1);
        if (relPath.length() == 0) {
            return root;
        }
        try {
            return root.getNode(relPath);
        }
        catch (PathNotFoundException e) {
            return root.getProperty(relPath);
        }
    }

    public boolean itemExists(String absPath) throws RepositoryException {
        try {
            this.getItem(absPath);
            return true;
        }
        catch (PathNotFoundException e) {
            return false;
        }
    }

    public Session impersonate(Credentials credentials) throws RepositoryException {
        return this.getRepository().login(credentials, this.getWorkspace().getName());
    }

    private ContentHandler getExportContentHandler(OutputStream stream) throws RepositoryException {
        try {
            SAXTransformerFactory stf = (SAXTransformerFactory)SAXTransformerFactory.newInstance();
            TransformerHandler handler = stf.newTransformerHandler();
            Transformer transformer = handler.getTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", "UTF-8");
            transformer.setOutputProperty("indent", "no");
            handler.setResult(new StreamResult(stream));
            return handler;
        }
        catch (TransformerFactoryConfigurationError e) {
            throw new RepositoryException("SAX transformer implementation not available", (Throwable)e);
        }
        catch (TransformerException e) {
            throw new RepositoryException("Error creating an XML export content handler", (Throwable)e);
        }
    }
}

