/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.stats;

import org.apache.jackrabbit.api.stats.TimeSeries;

public class TimeSeriesAverage
implements TimeSeries {
    private final TimeSeries value;
    private final TimeSeries counter;

    public TimeSeriesAverage(TimeSeries value, TimeSeries counter) {
        this.value = value;
        this.counter = counter;
    }

    public long[] getValuePerSecond() {
        long[] values = this.value.getValuePerSecond();
        long[] counts = this.counter.getValuePerSecond();
        return this.divide(values, counts);
    }

    public long[] getValuePerMinute() {
        long[] values = this.value.getValuePerMinute();
        long[] counts = this.counter.getValuePerMinute();
        return this.divide(values, counts);
    }

    public synchronized long[] getValuePerHour() {
        long[] values = this.value.getValuePerHour();
        long[] counts = this.counter.getValuePerHour();
        return this.divide(values, counts);
    }

    public synchronized long[] getValuePerWeek() {
        long[] values = this.value.getValuePerWeek();
        long[] counts = this.counter.getValuePerWeek();
        return this.divide(values, counts);
    }

    private long[] divide(long[] a, long[] b) {
        long[] c = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = b[i] != 0L ? a[i] / b[i] : 0L;
        }
        return c;
    }
}

