/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.commons;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.imageio.spi.ServiceRegistry;
import javax.jcr.Binary;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.PropertyType;
import javax.jcr.Repository;
import javax.jcr.RepositoryException;
import javax.jcr.RepositoryFactory;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.Row;
import org.apache.jackrabbit.commons.iterator.NodeIterable;
import org.apache.jackrabbit.commons.iterator.PropertyIterable;
import org.apache.jackrabbit.commons.iterator.RowIterable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JcrUtils {
    public static final String REPOSITORY_URI = "org.apache.jackrabbit.repository.uri";
    public static final Value[] NO_VALUES = new Value[0];
    private static final List<String> PROPERTY_TYPES_NAMES = new ArrayList<String>();
    private static final Map<String, Integer> PROPERTY_TYPES = new HashMap<String, Integer>();

    private JcrUtils() {
    }

    public static Repository getRepository() throws RepositoryException {
        return JcrUtils.getRepository((Map<String, String>)null);
    }

    public static Repository getRepository(Map<String, String> parameters) throws RepositoryException {
        String newline = System.getProperty("line.separator");
        StringBuilder log = new StringBuilder("Unable to access a repository");
        if (parameters != null) {
            log.append(" with the following settings:");
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                log.append(newline);
                log.append("    ");
                log.append(entry.getKey());
                log.append(": ");
                log.append(entry.getValue());
            }
        } else {
            log.append(" with the default settings.");
        }
        if (parameters != null && parameters.containsKey(REPOSITORY_URI)) {
            String uri = parameters.get(REPOSITORY_URI);
            try {
                URI u = new URI(uri);
                String query = u.getRawQuery();
                if (query != null) {
                    HashMap<String, String> copy = new HashMap<String, String>(parameters);
                    for (String entry : query.split("&")) {
                        int i = entry.indexOf(61);
                        if (i != -1) {
                            copy.put(URLDecoder.decode(entry.substring(0, i), "UTF-8"), URLDecoder.decode(entry.substring(i + 1), "UTF-8"));
                            continue;
                        }
                        copy.put(URLDecoder.decode(entry, "UTF-8"), Boolean.TRUE.toString());
                    }
                    copy.put(REPOSITORY_URI, new URI(u.getScheme(), u.getRawAuthority(), u.getRawPath(), null, u.getRawFragment()).toASCIIString());
                    parameters = copy;
                }
            }
            catch (URISyntaxException e) {
                log.append(newline);
                log.append("Note that the given repository URI was invalid:");
                log.append(newline);
                log.append("        ").append(uri);
                log.append(newline);
                log.append("        ").append(e.getMessage());
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException("UTF-8 is not supported!", (Throwable)e);
            }
        }
        log.append(newline);
        log.append("The following RepositoryFactory classes were consulted:");
        Iterator<RepositoryFactory> iterator = ServiceRegistry.lookupProviders(RepositoryFactory.class);
        while (iterator.hasNext()) {
            RepositoryFactory factory = iterator.next();
            log.append(newline);
            log.append("    ");
            log.append(factory.getClass().getName());
            try {
                Repository repository = factory.getRepository(parameters);
                if (repository != null) {
                    return repository;
                }
                log.append(": declined");
            }
            catch (Exception e) {
                log.append(": failed");
                for (Throwable c = e; c != null; c = c.getCause()) {
                    log.append(newline);
                    log.append("        because of ");
                    log.append(c.getClass().getSimpleName());
                    log.append(": ");
                    log.append(c.getMessage());
                }
            }
        }
        log.append(newline);
        log.append("Perhaps the repository you are trying to access is not available at the moment.");
        throw new RepositoryException(log.toString());
    }

    public static Repository getRepository(String uri) throws RepositoryException {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put(REPOSITORY_URI, uri);
        return JcrUtils.getRepository(parameters);
    }

    public static Iterable<Node> getSharedSet(Node node) throws RepositoryException {
        return new NodeIterable(node.getSharedSet());
    }

    public static Iterable<Node> getChildNodes(Node node) throws RepositoryException {
        return new NodeIterable(node.getNodes());
    }

    public static Iterable<Node> getChildNodes(Node node, String pattern) throws RepositoryException {
        return new NodeIterable(node.getNodes(pattern));
    }

    public static Iterable<Node> getChildNodes(Node node, String[] globs) throws RepositoryException {
        return new NodeIterable(node.getNodes(globs));
    }

    public static Iterable<Property> getProperties(Node node) throws RepositoryException {
        return new PropertyIterable(node.getProperties());
    }

    public static Iterable<Property> getProperties(Node node, String pattern) throws RepositoryException {
        return new PropertyIterable(node.getProperties(pattern));
    }

    public static Iterable<Property> getProperties(Node node, String[] globs) throws RepositoryException {
        return new PropertyIterable(node.getProperties(globs));
    }

    public static Iterable<Property> getReferences(Node node) throws RepositoryException {
        return new PropertyIterable(node.getReferences());
    }

    public static Iterable<Property> getReferences(Node node, String name) throws RepositoryException {
        return new PropertyIterable(node.getReferences(name));
    }

    public static Iterable<Property> getWeakReferences(Node node) throws RepositoryException {
        return new PropertyIterable(node.getWeakReferences());
    }

    public static Iterable<Property> getWeakReferences(Node node, String name) throws RepositoryException {
        return new PropertyIterable(node.getWeakReferences(name));
    }

    public static Iterable<Node> getNodes(QueryResult result) throws RepositoryException {
        return new NodeIterable(result.getNodes());
    }

    public static Iterable<Row> getRows(QueryResult result) throws RepositoryException {
        return new RowIterable(result.getRows());
    }

    public static Node getOrAddNode(Node parent, String name) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name);
    }

    public static Node getOrAddNode(Node parent, String name, String type) throws RepositoryException {
        if (parent.hasNode(name)) {
            return parent.getNode(name);
        }
        return parent.addNode(name, type);
    }

    public static Node getOrAddFolder(Node parent, String name) throws RepositoryException {
        return JcrUtils.getOrAddNode(parent, name, "{http://www.jcp.org/jcr/nt/1.0}folder");
    }

    public static Node putFile(Node parent, String name, String mime, InputStream data) throws RepositoryException {
        return JcrUtils.putFile(parent, name, mime, data, Calendar.getInstance());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Node putFile(Node parent, String name, String mime, InputStream data, Calendar date) throws RepositoryException {
        Binary binary = parent.getSession().getValueFactory().createBinary(data);
        try {
            Node file = JcrUtils.getOrAddNode(parent, name, "{http://www.jcp.org/jcr/nt/1.0}file");
            Node content = JcrUtils.getOrAddNode(file, "{http://www.jcp.org/jcr/1.0}content", "{http://www.jcp.org/jcr/nt/1.0}resource");
            content.setProperty("{http://www.jcp.org/jcr/1.0}mimeType", mime);
            String[] parameters = mime.split(";");
            for (int i = 1; i < parameters.length; ++i) {
                String parameter;
                int equals = parameters[i].indexOf(61);
                if (equals == -1 || !"charset".equalsIgnoreCase((parameter = parameters[i].substring(0, equals)).trim())) continue;
                content.setProperty("{http://www.jcp.org/jcr/1.0}encoding", parameters[i].substring(equals + 1).trim());
            }
            content.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", date);
            content.setProperty("{http://www.jcp.org/jcr/1.0}data", binary);
            Node node = file;
            return node;
        }
        finally {
            binary.dispose();
        }
    }

    public InputStream readFile(Node node) throws RepositoryException {
        if (node.hasProperty("{http://www.jcp.org/jcr/1.0}data")) {
            Property data = node.getProperty("{http://www.jcp.org/jcr/1.0}data");
            final Binary binary = data.getBinary();
            return new FilterInputStream(binary.getStream()){

                public void close() throws IOException {
                    super.close();
                    binary.dispose();
                }
            };
        }
        if (node.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            return this.readFile(node.getNode("{http://www.jcp.org/jcr/1.0}content"));
        }
        throw new RepositoryException("Unable to read file node: " + node.getPath());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFile(Node node, OutputStream output) throws RepositoryException, IOException {
        InputStream input = this.readFile(node);
        try {
            byte[] buffer = new byte[16384];
            int n = input.read(buffer);
            while (n != -1) {
                output.write(buffer, 0, n);
                n = input.read(buffer);
            }
        }
        finally {
            input.close();
        }
    }

    public Calendar getLastModified(Node node) throws RepositoryException {
        if (node.hasProperty("{http://www.jcp.org/jcr/1.0}lastModified")) {
            return node.getProperty("{http://www.jcp.org/jcr/1.0}lastModified").getDate();
        }
        if (node.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            return this.getLastModified(node.getNode("{http://www.jcp.org/jcr/1.0}content"));
        }
        return null;
    }

    public void setLastModified(Node node, Calendar date) throws RepositoryException {
        if (node.hasNode("{http://www.jcp.org/jcr/1.0}content")) {
            this.setLastModified(node.getNode("{http://www.jcp.org/jcr/1.0}content"), date);
        } else {
            node.setProperty("{http://www.jcp.org/jcr/1.0}lastModified", date);
        }
    }

    public static String toString(Item item) {
        StringBuilder builder = new StringBuilder();
        try {
            if (item.isNode()) {
                builder.append(item.getPath());
                builder.append(" [");
                builder.append(((Node)item).getPrimaryNodeType().getName());
                builder.append("]");
            } else {
                builder.append("@");
                builder.append(item.getName());
                builder.append(" = ");
                Property property = (Property)item;
                if (property.isMultiple()) {
                    builder.append("[ ");
                    Value[] values = property.getValues();
                    for (int i = 0; i < values.length && i < 3; ++i) {
                        if (i > 0) {
                            builder.append(", ");
                        }
                        JcrUtils.append(builder, values[i]);
                    }
                    if (values.length >= 3) {
                        builder.append(", ...");
                    }
                    builder.append(" ]");
                } else {
                    JcrUtils.append(builder, property.getValue());
                }
            }
        }
        catch (RepositoryException e) {
            builder.append("!!! ");
            builder.append(e.getMessage());
            builder.append(" !!!");
        }
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void append(StringBuilder builder, Value value) throws RepositoryException {
        if (value.getType() == 2) {
            Binary binary = value.getBinary();
            try {
                builder.append("<");
                builder.append(binary.getSize());
                builder.append(" bytes>");
            }
            finally {
                binary.dispose();
            }
        } else {
            String string = value.getString();
            if (string.length() > 40) {
                builder.append(string.substring(0, 37));
                builder.append("...");
            } else {
                builder.append(string);
            }
        }
    }

    public static int getPropertyType(String name) throws IllegalArgumentException {
        Integer type = PROPERTY_TYPES.get(name.toLowerCase());
        if (type != null) {
            return type;
        }
        throw new IllegalArgumentException("Unknown property type: " + name);
    }

    public static String[] getPropertyTypeNames(boolean includeUndefined) {
        if (includeUndefined) {
            return PROPERTY_TYPES_NAMES.toArray(new String[PROPERTY_TYPES_NAMES.size()]);
        }
        String[] typeNames = new String[PROPERTY_TYPES_NAMES.size() - 1];
        int i = 0;
        for (String name : PROPERTY_TYPES_NAMES) {
            if ("undefined".equals(name)) continue;
            typeNames[i++] = name;
        }
        return typeNames;
    }

    public static Node getOrCreateByPath(String absolutePath, String nodeType, Session session) throws RepositoryException {
        return JcrUtils.getOrCreateByPath(absolutePath, false, nodeType, nodeType, session, false);
    }

    public static Node getOrCreateByPath(String absolutePath, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        return JcrUtils.getOrCreateByPath(absolutePath, false, intermediateNodeType, nodeType, session, autoSave);
    }

    public static Node getOrCreateUniqueByPath(String pathHint, String nodeType, Session session) throws RepositoryException {
        return JcrUtils.getOrCreateByPath(pathHint, true, nodeType, nodeType, session, false);
    }

    public static Node getOrCreateByPath(String absolutePath, boolean createUniqueLeaf, String intermediateNodeType, String nodeType, Session session, boolean autoSave) throws RepositoryException {
        if (absolutePath == null || absolutePath.length() == 0 || "/".equals(absolutePath)) {
            return session.getRootNode();
        }
        return JcrUtils.getOrCreateByPath(session.getRootNode(), absolutePath.substring(1), createUniqueLeaf, intermediateNodeType, nodeType, autoSave);
    }

    public static Node getOrCreateUniqueByPath(Node parent, String nodeNameHint, String nodeType) throws RepositoryException {
        return JcrUtils.getOrCreateByPath(parent, nodeNameHint, true, nodeType, nodeType, false);
    }

    public static Node getOrCreateByPath(Node baseNode, String path, boolean createUniqueLeaf, String intermediateNodeType, String nodeType, boolean autoSave) throws RepositoryException {
        if (!createUniqueLeaf && baseNode.hasNode(path)) {
            return baseNode.getNode(path);
        }
        Node node = baseNode;
        int pos = path.lastIndexOf(47);
        if (pos != -1) {
            StringTokenizer st = new StringTokenizer(path.substring(0, pos), "/");
            while (st.hasMoreTokens()) {
                String token = st.nextToken();
                if (!node.hasNode(token)) {
                    try {
                        if (intermediateNodeType != null) {
                            node.addNode(token, intermediateNodeType);
                        } else {
                            node.addNode(token);
                        }
                        if (autoSave) {
                            node.getSession().save();
                        }
                    }
                    catch (RepositoryException e) {
                        node.refresh(false);
                    }
                }
                node = node.getNode(token);
            }
            path = path.substring(pos + 1);
        }
        if (!node.hasNode(path)) {
            if (nodeType != null) {
                node.addNode(path, nodeType);
            } else {
                node.addNode(path);
            }
            if (autoSave) {
                node.getSession().save();
            }
        } else if (createUniqueLeaf) {
            String leafNodeName;
            int i = 0;
            do {
                leafNodeName = path + String.valueOf(i);
                ++i;
            } while (node.hasNode(leafNodeName));
            Node leaf = nodeType != null ? node.addNode(leafNodeName, nodeType) : node.addNode(leafNodeName);
            if (autoSave) {
                node.getSession().save();
            }
            return leaf;
        }
        return node.getNode(path);
    }

    static {
        for (int i = 0; i <= 12; ++i) {
            String typeName = PropertyType.nameFromValue((int)i);
            PROPERTY_TYPES_NAMES.add(typeName);
            PROPERTY_TYPES.put(typeName.toLowerCase(), i);
        }
    }
}

