/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.webdav.jcr;

import java.io.IOException;
import java.security.AccessControlException;
import java.util.ArrayList;
import javax.jcr.Item;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Workspace;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavCompliance;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavResource;
import org.apache.jackrabbit.webdav.DavResourceFactory;
import org.apache.jackrabbit.webdav.DavResourceLocator;
import org.apache.jackrabbit.webdav.io.OutputContext;
import org.apache.jackrabbit.webdav.jcr.AbstractResource;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.jcr.JcrDavException;
import org.apache.jackrabbit.webdav.jcr.JcrDavSession;
import org.apache.jackrabbit.webdav.jcr.nodetype.ItemDefinitionImpl;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeDefinitionImpl;
import org.apache.jackrabbit.webdav.jcr.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.webdav.lock.LockEntry;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.ObservationResource;
import org.apache.jackrabbit.webdav.observation.Subscription;
import org.apache.jackrabbit.webdav.observation.SubscriptionDiscovery;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.observation.SubscriptionManager;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.transaction.TxLockEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractItemResource
extends AbstractResource
implements ObservationResource,
ItemResourceConstants {
    private static Logger log = LoggerFactory.getLogger((Class)AbstractItemResource.class);
    private SubscriptionManager subsMgr;
    protected final Item item;

    AbstractItemResource(DavResourceLocator locator, JcrDavSession session, DavResourceFactory factory, Item item) {
        super(locator, session, factory);
        this.item = item;
        this.initLockSupport();
        this.initSupportedReports();
    }

    public String getComplianceClass() {
        return DavCompliance.concatComplianceClasses((String[])new String[]{super.getComplianceClass(), "observation"});
    }

    public String getSupportedMethods() {
        return "OPTIONS, GET, HEAD, POST, TRACE, PROPFIND, PROPPATCH, MKCOL, COPY, PUT, DELETE, MOVE, LOCK, UNLOCK, SUBSCRIBE, UNSUBSCRIBE, POLL, SEARCH, REPORT";
    }

    public boolean exists() {
        return this.item != null;
    }

    public String getDisplayName() {
        String resPath = this.getResourcePath();
        return resPath != null ? Text.getName((String)resPath) : resPath;
    }

    public void spool(OutputContext outputContext) throws IOException {
        DavProperty contentLanguage;
        DavProperty contentLength;
        DavProperty contentType;
        if (!this.initedProps) {
            this.initProperties();
        }
        outputContext.setModificationTime(this.getModificationTime());
        DavProperty etag = this.getProperty(DavPropertyName.GETETAG);
        if (etag != null) {
            outputContext.setETag(String.valueOf(etag.getValue()));
        }
        if ((contentType = this.getProperty(DavPropertyName.GETCONTENTTYPE)) != null) {
            outputContext.setContentType(String.valueOf(contentType.getValue()));
        }
        if ((contentLength = this.getProperty(DavPropertyName.GETCONTENTLENGTH)) != null) {
            try {
                long length = Long.parseLong(contentLength.getValue() + "");
                if (length > 0L) {
                    outputContext.setContentLength(length);
                }
            }
            catch (NumberFormatException e) {
                log.error("Could not build content length from property value '" + contentLength.getValue() + "'");
            }
        }
        if ((contentLanguage = this.getProperty(DavPropertyName.GETCONTENTLANGUAGE)) != null) {
            outputContext.setContentLanguage(contentLanguage.getValue().toString());
        }
    }

    public DavResource getCollection() {
        DavResource collection = null;
        String parentPath = Text.getRelativeParent((String)this.getResourcePath(), (int)1);
        DavResourceLocator parentLoc = this.getLocator().getFactory().createResourceLocator(this.getLocator().getPrefix(), this.getLocator().getWorkspacePath(), parentPath);
        try {
            collection = this.createResourceFromLocator(parentLoc);
        }
        catch (DavException e) {
            log.error("Unexpected error while retrieving collection: " + e.getMessage());
        }
        return collection;
    }

    public void move(DavResource destination) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        DavResourceLocator destLocator = destination.getLocator();
        if (!this.getLocator().isSameWorkspace(destLocator)) {
            throw new DavException(403);
        }
        try {
            String itemPath = this.getLocator().getRepositoryPath();
            String destItemPath = destination.getLocator().getRepositoryPath();
            if (this.getTransactionId() == null) {
                this.getRepositorySession().getWorkspace().move(itemPath, destItemPath);
            } else {
                this.getRepositorySession().move(itemPath, destItemPath);
            }
        }
        catch (PathNotFoundException e) {
            throw new DavException(409, e.getMessage());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void copy(DavResource destination, boolean shallow) throws DavException {
        if (!this.exists()) {
            throw new DavException(404);
        }
        if (shallow) {
            throw new DavException(403, "Unable to perform shallow copy.");
        }
        try {
            String itemPath = this.getLocator().getRepositoryPath();
            String destItemPath = destination.getLocator().getRepositoryPath();
            Workspace workspace = this.getRepositorySession().getWorkspace();
            if (!this.getLocator().isSameWorkspace(destination.getLocator())) {
                log.error("Copy between workspaces is not yet implemented (src: '" + this.getHref() + "', dest: '" + destination.getHref() + "')");
                throw new DavException(501);
            }
            workspace.copy(itemPath, destItemPath);
        }
        catch (PathNotFoundException e) {
            throw new DavException(404, e.getMessage());
        }
        catch (RepositoryException e) {
            throw new JcrDavException(e);
        }
    }

    public void init(SubscriptionManager subsMgr) {
        this.subsMgr = subsMgr;
    }

    public Subscription subscribe(SubscriptionInfo info, String subscriptionId) throws DavException {
        return this.subsMgr.subscribe(info, subscriptionId, (ObservationResource)this);
    }

    public void unsubscribe(String subscriptionId) throws DavException {
        this.subsMgr.unsubscribe(subscriptionId, (ObservationResource)this);
    }

    public EventDiscovery poll(String subscriptionId, long timeout) throws DavException {
        return this.subsMgr.poll(subscriptionId, timeout, (ObservationResource)this);
    }

    protected void initLockSupport() {
        if (this.exists()) {
            this.supportedLock.addEntry((LockEntry)new TxLockEntry(true));
            this.supportedLock.addEntry((LockEntry)new TxLockEntry(false));
        }
    }

    protected void initProperties() {
        super.initProperties();
        if (this.exists()) {
            try {
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_NAME, (Object)this.item.getName()));
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_PATH, (Object)this.item.getPath()));
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_DEPTH, (Object)String.valueOf(this.item.getDepth())));
                if (this.item.getDepth() > 0) {
                    String parentHref = this.getLocatorFromItem((Item)this.item.getParent()).getHref(true);
                    this.properties.add((DavProperty)new HrefProperty(JCR_PARENT, parentHref, false));
                }
                ItemDefinitionImpl val = this.item.isNode() ? NodeDefinitionImpl.create(((Node)this.item).getDefinition()) : PropertyDefinitionImpl.create(((Property)this.item).getDefinition());
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_DEFINITION, (Object)val, true));
            }
            catch (RepositoryException e) {
                log.error("Error while accessing jcr properties: " + e.getMessage());
            }
            if (this.item.isNew()) {
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_ISNEW, null, true));
            } else if (this.item.isModified()) {
                this.properties.add((DavProperty)new DefaultDavProperty(JCR_ISMODIFIED, null, true));
            }
        }
        SubscriptionDiscovery subsDiscovery = this.subsMgr.getSubscriptionDiscovery((ObservationResource)this);
        this.properties.add((DavProperty)subsDiscovery);
        Privilege[] allPrivs = new Privilege[]{PRIVILEGE_JCR_READ, PRIVILEGE_JCR_ADD_NODE, PRIVILEGE_JCR_SET_PROPERTY, PRIVILEGE_JCR_REMOVE};
        ArrayList<Privilege> currentPrivs = new ArrayList<Privilege>();
        for (int i = 0; i < allPrivs.length; ++i) {
            try {
                this.getRepositorySession().checkPermission(this.getLocator().getRepositoryPath(), allPrivs[i].getName());
                currentPrivs.add(allPrivs[i]);
                continue;
            }
            catch (AccessControlException e) {
                log.debug(e.toString());
                continue;
            }
            catch (RepositoryException e) {
                log.debug(e.toString());
            }
        }
        this.properties.add((DavProperty)new CurrentUserPrivilegeSetProperty(currentPrivs.toArray(new Privilege[currentPrivs.size()])));
    }

    protected String getWorkspaceHref() {
        String workspaceHref = null;
        DavResourceLocator locator = this.getLocator();
        if (locator != null && locator.getWorkspacePath() != null) {
            String wspPath = locator.getWorkspacePath();
            DavResourceLocator wspLocator = locator.getFactory().createResourceLocator(locator.getPrefix(), wspPath, wspPath);
            workspaceHref = wspLocator.getHref(true);
        }
        log.debug(workspaceHref);
        return workspaceHref;
    }

    void complete() throws DavException {
        if (this.exists() && this.getTransactionId() == null) {
            try {
                if (this.item.isModified()) {
                    this.item.save();
                }
            }
            catch (RepositoryException e) {
                log.error("Error while completing request: " + e.getMessage() + " -> reverting changes.");
                try {
                    this.item.refresh(false);
                }
                catch (RepositoryException re) {
                    log.error("Error while reverting changes: " + re.getMessage());
                }
                throw new JcrDavException(e);
            }
        }
    }

    protected static String getItemName(String itemPath) {
        if (itemPath == null) {
            throw new IllegalArgumentException("Cannot retrieve name from a 'null' item path.");
        }
        String name = Text.getName((String)itemPath);
        if (name.endsWith("]")) {
            name = name.substring(0, name.lastIndexOf(91));
        }
        return name;
    }
}

