/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api;

import java.util.Calendar;
import java.util.GregorianCalendar;
import javax.jcr.Node;
import javax.jcr.PathNotFoundException;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.test.AbstractJCRTest;

public class SetValueDateTest
extends AbstractJCRTest {
    private Value value;
    private Node node;
    private Property property1;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.value = this.superuser.getValueFactory().createValue(GregorianCalendar.getInstance());
        this.node = this.testRootNode.addNode(this.nodeName1, this.testNodeType);
        Calendar initialValue = GregorianCalendar.getInstance();
        initialValue.setTimeInMillis(0L);
        this.property1 = this.node.setProperty(this.propertyName1, initialValue);
        this.superuser.save();
    }

    @Override
    protected void tearDown() throws Exception {
        this.value = null;
        this.node = null;
        this.property1 = null;
        super.tearDown();
    }

    public void testDateSession() throws RepositoryException {
        this.property1.setValue(this.value);
        this.superuser.save();
        SetValueDateTest.assertEquals((String)"Date node property not saved", (Object)this.value, (Object)this.property1.getValue());
    }

    public void testDateParent() throws RepositoryException {
        this.property1.setValue(this.value.getDate());
        this.node.save();
        Value orig = this.superuser.getValueFactory().createValue(this.value.getDate());
        SetValueDateTest.assertEquals((String)"Date node property not saved", (Object)orig, (Object)this.property1.getValue());
    }

    public void testRemoveDateParent() throws RepositoryException {
        this.property1.setValue((Value)null);
        this.node.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueDateTest.fail((String)"The property should not exist anymore, as a null Value has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }

    public void testRemoveCalendarSession() throws RepositoryException {
        this.property1.setValue((Calendar)null);
        this.superuser.save();
        try {
            this.node.getProperty(this.propertyName1);
            SetValueDateTest.fail((String)"The property should not exist anymore, as a null Calendar has been assigned");
        }
        catch (PathNotFoundException pathNotFoundException) {
            // empty catch block
        }
    }
}

