/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.observation;

import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.test.NotExecutableException;
import org.apache.jackrabbit.test.api.observation.AbstractObservationTest;

public class GetUserDataTest
extends AbstractObservationTest {
    public void testSave() throws RepositoryException {
        this.runWithUserData(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetUserDataTest.this.testRootNode.addNode(GetUserDataTest.this.nodeName1, GetUserDataTest.this.testNodeType);
                GetUserDataTest.this.testRootNode.getSession().save();
            }
        }, 63);
    }

    public void testWorkspaceOperation() throws RepositoryException {
        this.testRootNode.addNode(this.nodeName1);
        this.testRootNode.getSession().save();
        this.runWithUserData(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                String src = GetUserDataTest.this.testRoot + "/" + GetUserDataTest.this.nodeName1;
                String dest = GetUserDataTest.this.testRoot + "/" + GetUserDataTest.this.nodeName2;
                GetUserDataTest.this.superuser.getWorkspace().move(src, dest);
            }
        }, 63);
    }

    public void testVersioning() throws RepositoryException, NotExecutableException {
        this.checkSupportedOption("option.versioning.supported");
        final Node n1 = this.testRootNode.addNode(this.nodeName1);
        this.ensureMixinType(n1, this.mixVersionable);
        this.testRootNode.getSession().save();
        this.runWithUserData(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                n1.checkin();
            }
        }, 1);
    }

    protected void runWithUserData(final AbstractObservationTest.Callable c, int eventTypes) throws RepositoryException {
        final String data = this.createRandomString(5);
        Event[] events = this.getEvents(new AbstractObservationTest.Callable(){

            @Override
            public void call() throws RepositoryException {
                GetUserDataTest.this.obsMgr.setUserData(data);
                c.call();
            }
        }, eventTypes);
        GetUserDataTest.assertTrue((String)"no events returned", (events.length > 0 ? 1 : 0) != 0);
        for (int i = 0; i < events.length; ++i) {
            GetUserDataTest.assertEquals((String)"Wrong user data", (String)data, (String)events[i].getUserData());
        }
    }
}

