/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.test.api.query;

import javax.jcr.NodeIterator;
import javax.jcr.RangeIterator;
import javax.jcr.Value;
import javax.jcr.query.QueryResult;
import javax.jcr.query.RowIterator;
import org.apache.jackrabbit.test.api.query.AbstractQueryLevel2Test;
import org.apache.jackrabbit.test.api.query.Statement;

public class XPathQueryLevel2Test
extends AbstractQueryLevel2Test {
    public void testScoreColumn() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        RowIterator rows = result.getRows();
        rows.nextRow().getValue(this.jcrScore);
    }

    public void testFullTextSearch() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        this.checkResult(result, 1);
        NodeIterator itr = result.getNodes();
        while (itr.hasNext()) {
            String fullText;
            Value value = itr.nextNode().getProperty(this.propertyName1).getValue();
            if (value == null || (fullText = value.getString()).indexOf("cat") <= 0) continue;
            XPathQueryLevel2Test.fail((String)"Search Text: full text search not correct, returned prohibited text");
        }
    }

    public void testRange() throws Exception {
        this.setUpRangeTest();
        QueryResult result = this.execute(this.getRangeStatement());
        this.checkResult(result, 1);
        this.checkValue(result.getNodes(), this.propertyName1, "b");
    }

    public void testMultiValueSearch() throws Exception {
        this.setUpMultiValueTest();
        QueryResult result = this.execute(this.getMultiValueStatement());
        this.checkResult(result, 1);
        this.checkValue(result.getNodes(), this.propertyName1, "existence");
    }

    public void testPathColumn() throws Exception {
        this.setUpFullTextTest();
        QueryResult result = this.execute(this.getFullTextStatement());
        RowIterator rows = result.getRows();
        if (this.getSize((RangeIterator)rows) < 1L) {
            XPathQueryLevel2Test.fail((String)"Query result did not return any nodes");
        }
        rows = result.getRows();
        rows.nextRow().getValue(this.jcrPath);
    }

    private Statement getFullTextStatement() {
        String xpath = this.xpathRoot + "/*[" + this.jcrContains + "(., '\"quick brown\" -cat')]";
        return new Statement(xpath, this.qsXPATH);
    }

    private Statement getMultiValueStatement() {
        String xpath = this.xpathRoot + "/*[@" + this.propertyName2 + " = 'two' and @" + this.propertyName1 + " = 'existence']";
        return new Statement(xpath, this.qsXPATH);
    }

    private Statement getRangeStatement() {
        String xpath = this.xpathRoot + "/*[@" + this.propertyName1 + " <= 'b' and @" + this.propertyName1 + " > 'a']";
        return new Statement(xpath, this.qsXPATH);
    }
}

