/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.jcr2spi;

import java.util.Iterator;
import javax.jcr.AccessDeniedException;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemExistsException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.MergeException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.version.Version;
import javax.jcr.version.VersionException;
import javax.jcr.version.VersionHistory;
import org.apache.jackrabbit.commons.iterator.NodeIteratorAdapter;
import org.apache.jackrabbit.jcr2spi.ItemManager;
import org.apache.jackrabbit.jcr2spi.LazyItemIterator;
import org.apache.jackrabbit.jcr2spi.NodeImpl;
import org.apache.jackrabbit.jcr2spi.SessionImpl;
import org.apache.jackrabbit.jcr2spi.hierarchy.NodeEntry;
import org.apache.jackrabbit.jcr2spi.state.NodeState;
import org.apache.jackrabbit.jcr2spi.version.VersionManager;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JcrVersionManager
implements javax.jcr.version.VersionManager {
    private static final Logger log = LoggerFactory.getLogger(JcrVersionManager.class);
    private final VersionManager vMgr;
    private final SessionImpl session;
    private final ItemManager itemManager;
    private final PathResolver resolver;
    private NodeId activityId;

    protected JcrVersionManager(SessionImpl session) {
        this.session = session;
        this.vMgr = session.getVersionStateManager();
        this.itemManager = session.getItemManager();
        this.resolver = session.getPathResolver();
    }

    public Version checkin(String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.checkin();
    }

    public void checkout(String absPath) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.checkout();
    }

    public Version checkpoint(String absPath) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        this.session.checkIsAlive();
        NodeImpl n = (NodeImpl)this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.checkpoint();
    }

    public boolean isCheckedOut(String absPath) throws RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.isCheckedOut();
    }

    public VersionHistory getVersionHistory(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.getVersionHistory();
    }

    public Version getBaseVersion(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        return n.getBaseVersion();
    }

    public void restore(Version[] versions, boolean removeExisting) throws ItemExistsException, UnsupportedRepositoryOperationException, VersionException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        this.session.checkHasPendingChanges();
        NodeState[] versionStates = new NodeState[versions.length];
        for (int i = 0; i < versions.length; ++i) {
            versionStates[i] = this.session.getVersionState(versions[i]);
        }
        this.vMgr.restore(versionStates, removeExisting);
    }

    public void restore(String absPath, String versionName, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.restore(versionName, removeExisting);
    }

    public void restore(Version version, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, RepositoryException {
        this.restore(new Version[]{version}, removeExisting);
    }

    public void restore(String absPath, Version version, boolean removeExisting) throws PathNotFoundException, ItemExistsException, VersionException, ConstraintViolationException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        int idx = absPath.lastIndexOf("/");
        String parent = idx == 0 ? "/" : absPath.substring(0, idx);
        String name = absPath.substring(idx + 1);
        Node n = this.itemManager.getNode(this.resolver.getQPath(parent));
        n.restore(version, name, removeExisting);
    }

    public void restoreByLabel(String absPath, String versionLabel, boolean removeExisting) throws VersionException, ItemExistsException, UnsupportedRepositoryOperationException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.restoreByLabel(versionLabel, removeExisting);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.merge(absPath, srcWorkspace, bestEffort, false);
    }

    public NodeIterator merge(String absPath, String srcWorkspace, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        NodeImpl n = (NodeImpl)this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.checkIsWritable();
        this.session.checkHasPendingChanges();
        if (this.session.getWorkspace().getName().equals(srcWorkspace)) {
            return NodeIteratorAdapter.EMPTY;
        }
        this.session.checkAccessibleWorkspace(srcWorkspace);
        Iterator<NodeId> failedIds = this.session.getVersionStateManager().merge((NodeState)n.getItemState(), srcWorkspace, bestEffort, isShallow);
        return new LazyItemIterator(this.itemManager, this.session.getHierarchyManager(), failedIds);
    }

    public void doneMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.doneMerge(version);
    }

    public void cancelMerge(String absPath, Version version) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        Node n = this.itemManager.getNode(this.resolver.getQPath(absPath));
        n.cancelMerge(version);
    }

    public Node createConfiguration(String absPath) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        NodeImpl n = (NodeImpl)this.itemManager.getNode(this.resolver.getQPath(absPath));
        NodeEntry entry = this.vMgr.createConfiguration((NodeState)n.getItemState());
        return (Node)this.itemManager.getItem(entry);
    }

    public Node setActivity(Node activity) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        this.session.checkSupportedOption("option.activities.supported");
        Node oldActivity = this.getActivity();
        if (activity == null) {
            this.activityId = null;
        } else {
            NodeImpl activityNode = this.getValidActivity(activity, "set");
            this.activityId = (NodeId)activityNode.getItemState().getId();
        }
        return oldActivity;
    }

    public Node getActivity() throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        this.session.checkSupportedOption("option.activities.supported");
        if (this.activityId == null) {
            return null;
        }
        try {
            return (Node)this.itemManager.getItem(this.session.getHierarchyManager().getNodeEntry(this.activityId));
        }
        catch (ItemNotFoundException e) {
            log.warn("Activity node with id " + this.activityId + " doesn't exist any more.");
            this.activityId = null;
            return null;
        }
    }

    public Node createActivity(String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        NodeEntry entry = this.vMgr.createActivity(title);
        return (Node)this.itemManager.getItem(entry);
    }

    public void removeActivity(Node activityNode) throws UnsupportedRepositoryOperationException, RepositoryException {
        this.session.checkIsAlive();
        NodeImpl activity = this.getValidActivity(activityNode, "remove");
        NodeState nState = (NodeState)activity.getItemState();
        ItemId removeId = nState.getId();
        this.vMgr.removeActivity(nState);
        if (this.activityId != null && this.activityId.equals(removeId)) {
            this.activityId = null;
        }
    }

    public NodeIterator merge(Node activityNode) throws VersionException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        this.session.checkIsAlive();
        NodeImpl activity = this.getValidActivity(activityNode, "merge");
        Iterator<NodeId> failedIds = this.vMgr.mergeActivity((NodeState)activity.getItemState());
        return new LazyItemIterator(this.itemManager, this.session.getHierarchyManager(), failedIds);
    }

    private NodeImpl getValidActivity(Node activityNode, String methodName) throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeImpl activity;
        if (this.session != activityNode.getSession()) {
            String msg = "Attempt to " + methodName + " an activity node that has been retrieved by another session.";
            log.warn(msg);
            activity = (NodeImpl)this.session.getNodeByIdentifier(activityNode.getIdentifier());
        } else {
            activity = (NodeImpl)activityNode;
        }
        if (!activity.isNodeType(NameConstants.NT_ACTIVITY)) {
            throw new UnsupportedRepositoryOperationException("Given node is not an activity.");
        }
        return activity;
    }
}

