/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.observation;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.jcr.Value;
import javax.jcr.observation.Event;
import org.apache.jackrabbit.api.observation.JackrabbitEvent;
import org.apache.jackrabbit.oak.api.PropertyState;
import org.apache.jackrabbit.oak.commons.PathUtils;
import org.apache.jackrabbit.oak.namepath.NamePathMapper;
import org.apache.jackrabbit.oak.plugins.value.jcr.ValueFactoryImpl;
import org.apache.jackrabbit.oak.spi.commit.CommitInfo;

public class EventFactory {
    public static final String USER_DATA = "user-data";
    private final NamePathMapper mapper;
    private final String userID;
    private final String userData;
    private final long date;
    private final boolean external;

    EventFactory(NamePathMapper mapper, CommitInfo commitInfo) {
        this.mapper = mapper;
        if (!commitInfo.isExternal()) {
            this.userID = commitInfo.getUserId();
            Object userData = commitInfo.getInfo().get(USER_DATA);
            this.userData = userData instanceof String ? (String)userData : null;
            this.date = commitInfo.getDate();
            this.external = false;
        } else {
            this.userID = commitInfo.getUserId();
            this.userData = null;
            this.date = commitInfo.getDate();
            this.external = true;
        }
    }

    Event propertyAdded(final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 4;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put((Object)"afterValue", EventFactory.this.createValue(after)).build();
            }
        };
    }

    Event propertyChanged(final PropertyState before, final PropertyState after, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 16;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put((Object)"beforeValue", EventFactory.this.createValue(before)).put((Object)"afterValue", EventFactory.this.createValue(after)).build();
            }
        };
    }

    Event propertyDeleted(final PropertyState before, final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 8;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).put((Object)"beforeValue", EventFactory.this.createValue(before)).build();
            }
        };
    }

    private Object createValue(PropertyState property) {
        if (property.isArray()) {
            List values = ValueFactoryImpl.createValues((PropertyState)property, (NamePathMapper)this.mapper);
            return values.toArray(new Value[values.size()]);
        }
        return ValueFactoryImpl.createValue((PropertyState)property, (NamePathMapper)this.mapper);
    }

    Event nodeAdded(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 1;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeDeleted(final String primaryType, final Iterable<String> mixinTypes, String path, String name, String identifier) {
        return new EventImpl(path, name, identifier){

            public int getType() {
                return 2;
            }

            @Override
            public Map<?, ?> getInfo() {
                return EventFactory.this.createInfoMap(primaryType, mixinTypes);
            }
        };
    }

    Event nodeMoved(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String sourcePath) {
        return new EventImpl(parent, name, identifier){

            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().put((Object)"srcAbsPath", (Object)EventFactory.this.mapper.getJcrPath(sourcePath)).put((Object)"destAbsPath", (Object)this.getPath()).putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).build();
            }
        };
    }

    Event nodeReordered(final String primaryType, final Iterable<String> mixinTypes, String parent, String name, String identifier, final String destName) {
        return new EventImpl(parent, name, identifier){

            public int getType() {
                return 32;
            }

            @Override
            public Map<?, ?> getInfo() {
                return ImmutableMap.builder().put((Object)"srcChildRelPath", (Object)EventFactory.this.mapper.getJcrName(this.name)).put((Object)"destChildRelPath", (Object)EventFactory.this.mapper.getJcrName(destName)).putAll(EventFactory.this.createInfoMap(primaryType, mixinTypes)).build();
            }
        };
    }

    private Map<String, ?> createInfoMap(String primaryType, Iterable<String> mixinTypes) {
        if (Iterables.isEmpty(mixinTypes)) {
            return ImmutableMap.of((Object)"jcr:primaryType", (Object)this.mapper.getJcrName(primaryType));
        }
        ArrayList jcrNames = Lists.newArrayList();
        for (String name : mixinTypes) {
            jcrNames.add(this.mapper.getJcrName(name));
        }
        return ImmutableMap.of((Object)"jcr:primaryType", (Object)this.mapper.getJcrName(primaryType), (Object)"jcr:mixinTypes", (Object)Iterables.toArray((Iterable)jcrNames, String.class));
    }

    private abstract class EventImpl
    implements JackrabbitEvent {
        private final String parent;
        protected final String name;
        private final String identifier;

        EventImpl(String parent, String name, String identifier) {
            this.parent = parent;
            this.name = name;
            this.identifier = identifier;
        }

        public String getPath() {
            return PathUtils.concat((String)EventFactory.this.mapper.getJcrPath(this.parent), (String)EventFactory.this.mapper.getJcrName(this.name));
        }

        public String getIdentifier() {
            return this.identifier;
        }

        public Map<?, ?> getInfo() {
            return Collections.emptyMap();
        }

        public String getUserID() {
            return EventFactory.this.userID;
        }

        public String getUserData() {
            return EventFactory.this.userData;
        }

        public long getDate() {
            return EventFactory.this.date;
        }

        public boolean isExternal() {
            return EventFactory.this.external;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof EventImpl) {
                EventImpl that = (EventImpl)object;
                return this.getType() == that.getType() && this.getPath().equals(that.getPath()) && this.getIdentifier().equals(that.getIdentifier()) && this.getInfo().equals(that.getInfo()) && Objects.equal((Object)this.getUserID(), (Object)that.getUserID()) && Objects.equal((Object)this.getUserData(), (Object)that.getUserData()) && this.getDate() == that.getDate() && this.isExternal() == that.isExternal();
            }
            return false;
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getType(), this.getPath(), this.getIdentifier(), this.getInfo(), this.getUserID(), this.getUserData(), this.getDate(), this.isExternal()});
        }

        public String toString() {
            return Objects.toStringHelper((String)"Event").add("type", this.getType()).add("path", (Object)this.getPath()).add("identifier", (Object)this.getIdentifier()).add("info", this.getInfo()).add("userID", (Object)this.getUserID()).add("userData", (Object)this.getUserData()).add("date", this.getDate()).add("external", this.isExternal()).toString();
        }
    }
}

