/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.jcr.session;

import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.jcr.NamespaceException;
import org.apache.jackrabbit.oak.api.Root;
import org.apache.jackrabbit.oak.namepath.impl.LocalNameMapper;
import org.apache.jackrabbit.util.XMLChar;

public class SessionNamespaces
extends LocalNameMapper {
    public SessionNamespaces(@Nonnull Root root) {
        super(root, (Map)Maps.newHashMap());
    }

    synchronized void setNamespacePrefix(String prefix, String uri) throws NamespaceException {
        if (prefix == null) {
            throw new IllegalArgumentException("Prefix must not be null");
        }
        if (uri == null) {
            throw new IllegalArgumentException("Namespace must not be null");
        }
        if (prefix.isEmpty()) {
            throw new NamespaceException("Empty prefix is reserved and can not be remapped");
        }
        if (uri.isEmpty()) {
            throw new NamespaceException("Default namespace is reserved and can not be remapped");
        }
        if (prefix.toLowerCase(Locale.ENGLISH).startsWith("xml")) {
            throw new NamespaceException("XML prefixes are reserved: " + prefix);
        }
        if (!XMLChar.isValidNCName((String)prefix)) {
            throw new NamespaceException("Prefix is not a valid XML NCName: " + prefix);
        }
        this.local.remove(prefix);
        HashSet prefixes = new HashSet();
        for (Map.Entry entry : this.local.entrySet()) {
            if (!((String)entry.getValue()).equals(uri)) continue;
            prefixes.add(entry.getKey());
        }
        this.local.keySet().removeAll(prefixes);
        this.local.put(prefix, uri);
    }

    synchronized String[] getNamespacePrefixes() {
        Iterable global = this.getPrefixes();
        if (this.local.isEmpty()) {
            return (String[])Iterables.toArray((Iterable)global, String.class);
        }
        HashSet prefixes = Sets.newHashSet((Iterable)global);
        for (String uri : this.local.values()) {
            String prefix = this.getOakPrefixOrNull(uri);
            if (prefix == null) continue;
            prefixes.remove(prefix);
        }
        prefixes.addAll(this.local.keySet());
        return prefixes.toArray(new String[prefixes.size()]);
    }

    synchronized String getNamespaceURI(String prefix) throws NamespaceException {
        String uri = (String)this.local.get(prefix);
        if (uri == null && ((uri = this.getOakURIOrNull(prefix)) == null || this.local.containsValue(uri))) {
            throw new NamespaceException("Unknown namespace prefix: " + prefix);
        }
        return uri;
    }

    synchronized String getNamespacePrefix(String uri) throws NamespaceException {
        for (Map.Entry entry : this.local.entrySet()) {
            if (!((String)entry.getValue()).equals(uri)) continue;
            return (String)entry.getKey();
        }
        String prefix = this.getOakPrefixOrNull(uri);
        if (prefix == null) {
            throw new NamespaceException("Unknown namespace URI: " + uri);
        }
        String base = prefix;
        int i = 2;
        while (this.local.containsKey(prefix)) {
            prefix = base + i;
            ++i;
        }
        if (base != prefix) {
            this.local.put(prefix, uri);
        }
        return prefix;
    }

    synchronized void clear() {
        this.local.clear();
    }
}

