/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import java.io.IOException;
import java.util.List;
import org.apache.jackrabbit.oak.segment.aws.DynamoDBClient;
import org.apache.jackrabbit.oak.segment.spi.persistence.GCJournalFile;

public class AwsGCJournalFile
implements GCJournalFile {
    private final DynamoDBClient dynamoDBClient;
    private final String fileName;

    public AwsGCJournalFile(DynamoDBClient dynamoDBClient, String fileName) {
        this.dynamoDBClient = dynamoDBClient;
        this.fileName = fileName;
    }

    public void writeLine(String line) throws IOException {
        this.dynamoDBClient.putDocument(this.fileName, line);
    }

    public List<String> readLines() throws IOException {
        return this.dynamoDBClient.getDocumentContents(this.fileName);
    }

    public void truncate() throws IOException {
        this.dynamoDBClient.deleteAllDocuments(this.fileName);
    }
}

