/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.oak.segment.aws;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.jackrabbit.oak.commons.Buffer;
import org.apache.jackrabbit.oak.segment.aws.S3Directory;
import org.apache.jackrabbit.oak.segment.remote.AbstractRemoteSegmentArchiveReader;
import org.apache.jackrabbit.oak.segment.remote.RemoteSegmentArchiveEntry;
import org.apache.jackrabbit.oak.segment.remote.RemoteUtilities;
import org.apache.jackrabbit.oak.segment.spi.monitor.IOMonitor;

public class AwsSegmentArchiveReader
extends AbstractRemoteSegmentArchiveReader {
    private final S3Directory directory;
    private final String archiveName;
    private final long length;

    AwsSegmentArchiveReader(S3Directory directory, String archiveName, IOMonitor ioMonitor) throws IOException {
        super(ioMonitor);
        this.directory = directory;
        this.archiveName = archiveName;
        this.length = this.computeArchiveIndexAndLength();
    }

    public long length() {
        return this.length;
    }

    public String getName() {
        return this.archiveName;
    }

    protected long computeArchiveIndexAndLength() throws IOException {
        long length = 0L;
        Buffer buffer = this.directory.readObjectToBuffer(this.archiveName + ".idx", RemoteUtilities.OFF_HEAP);
        while (buffer.hasRemaining()) {
            long msb = buffer.getLong();
            long lsb = buffer.getLong();
            int position = buffer.getInt();
            int contentLength = buffer.getInt();
            int generation = buffer.getInt();
            int fullGeneration = buffer.getInt();
            boolean compacted = buffer.get() != 0;
            RemoteSegmentArchiveEntry indexEntry = new RemoteSegmentArchiveEntry(msb, lsb, position, contentLength, generation, fullGeneration, compacted);
            this.index.put(new UUID(indexEntry.getMsb(), indexEntry.getLsb()), indexEntry);
            length += (long)contentLength;
        }
        return length;
    }

    protected void doReadSegmentToBuffer(String segmentFileName, Buffer buffer) throws IOException {
        this.directory.readObjectToBuffer(segmentFileName, buffer);
    }

    protected Buffer doReadDataFile(String extension) throws IOException {
        return this.readObjectToBuffer(this.getName() + extension);
    }

    protected File archivePathAsFile() {
        return new File(this.directory.getPath());
    }

    private Buffer readObjectToBuffer(String name) throws IOException {
        if (this.directory.doesObjectExist(name)) {
            return this.directory.readObjectToBuffer(name, false);
        }
        return null;
    }
}

