/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.vault.fs.config;

import java.io.ByteArrayOutputStream;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import javax.jcr.Credentials;
import javax.jcr.SimpleCredentials;
import org.apache.jackrabbit.vault.fs.config.ConfigurationException;
import org.apache.jackrabbit.vault.fs.config.CredentialsConfig;
import org.apache.jackrabbit.vault.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class SimpleCredentialsConfig
extends CredentialsConfig {
    private static final int KEY_LENGTH = 8;
    private static final String PREFIX = "{DES}";
    private static final Logger log = LoggerFactory.getLogger(SimpleCredentialsConfig.class);
    private final SimpleCredentials creds;
    public static final String ELEM_USER = "user";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_PASSWORD = "password";

    public SimpleCredentialsConfig(SimpleCredentials creds) {
        super("simple");
        this.creds = creds;
    }

    @Override
    public Credentials getCredentials() {
        return this.creds;
    }

    public static SimpleCredentialsConfig load(Element elem) throws ConfigurationException {
        assert (elem.getNodeName().equals("credentials"));
        NodeList nl = elem.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node child = nl.item(i);
            if (child.getNodeType() != 1 || !child.getNodeName().equals(ELEM_USER)) continue;
            Element e = (Element)child;
            String name = e.getAttribute(ATTR_NAME);
            String pass = SimpleCredentialsConfig.decrypt(e.getAttribute(ATTR_PASSWORD));
            return new SimpleCredentialsConfig(new SimpleCredentials(name, pass == null ? new char[]{} : pass.toCharArray()));
        }
        throw new ConfigurationException("mandatory element <user> missing.");
    }

    @Override
    public void writeInner(ContentHandler handler) throws SAXException {
        if (this.creds != null) {
            AttributesImpl attrs = new AttributesImpl();
            attrs.addAttribute("", ATTR_NAME, "", "CDATA", this.creds.getUserID());
            attrs.addAttribute("", ATTR_PASSWORD, "", "CDATA", SimpleCredentialsConfig.encrypt(new String(this.creds.getPassword())));
            handler.startElement("", ELEM_USER, "", attrs);
            handler.endElement("", ELEM_USER, "");
        }
    }

    private static String encrypt(String s) {
        try {
            SecretKey key = KeyGenerator.getInstance("DES").generateKey();
            Cipher cipher = Cipher.getInstance("DES");
            byte[] keyBytes = key.getEncoded();
            byte[] data = s.getBytes("utf-8");
            ByteArrayOutputStream out = new ByteArrayOutputStream(keyBytes.length + data.length);
            out.write(keyBytes);
            cipher.init(1, key);
            out.write(cipher.update(data));
            out.write(cipher.doFinal());
            StringBuilder ret = new StringBuilder(PREFIX);
            for (byte b : out.toByteArray()) {
                ret.append(Text.hexTable[b >> 4 & 0xF]).append(Text.hexTable[b & 0xF]);
            }
            return ret.toString();
        }
        catch (Exception e) {
            log.warn("Unable to encrypt string: " + e);
            return null;
        }
    }

    private static String decrypt(String s) {
        if (s == null || !s.startsWith(PREFIX)) {
            return s;
        }
        try {
            byte[] data = new byte[(s.length() - PREFIX.length()) / 2];
            int i = PREFIX.length();
            int b = 0;
            while (i < s.length()) {
                data[b] = (byte)(Integer.parseInt(s.substring(i, i + 2), 16) & 0xFF);
                i += 2;
                ++b;
            }
            SecretKeySpec key = new SecretKeySpec(data, 0, 8, "DES");
            Cipher cipher = Cipher.getInstance("DES");
            ByteArrayOutputStream out = new ByteArrayOutputStream(data.length);
            cipher.init(2, key);
            out.write(cipher.update(data, 8, data.length - 8));
            out.write(cipher.doFinal());
            return out.toString("utf-8");
        }
        catch (Exception e) {
            log.warn("Unable to decrypt data: " + e);
            return null;
        }
    }
}

