/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.s3.blobstore.functions;

import com.google.common.base.Function;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.jclouds.blobstore.domain.MutableBlobMetadata;
import org.jclouds.blobstore.domain.StorageType;
import org.jclouds.blobstore.domain.internal.MutableBlobMetadataImpl;
import org.jclouds.domain.Location;
import org.jclouds.http.HttpUtils;
import org.jclouds.io.ContentMetadata;
import org.jclouds.io.MutableContentMetadata;
import org.jclouds.s3.domain.ObjectMetadata;

@Singleton
public class ObjectToBlobMetadata
implements Function<ObjectMetadata, MutableBlobMetadata> {
    private final Function<String, Location> locationOfBucket;

    @Inject
    public ObjectToBlobMetadata(Function<String, Location> locationOfBucket) {
        this.locationOfBucket = locationOfBucket;
    }

    public MutableBlobMetadata apply(ObjectMetadata from) {
        if (from == null) {
            return null;
        }
        MutableBlobMetadataImpl to = new MutableBlobMetadataImpl();
        HttpUtils.copy((ContentMetadata)from.getContentMetadata(), (MutableContentMetadata)to.getContentMetadata());
        to.setUri(from.getUri());
        to.setContainer(from.getBucket());
        to.setETag(from.getETag());
        to.setName(from.getKey());
        to.setLastModified(from.getLastModified());
        to.setUserMetadata(from.getUserMetadata());
        to.setLocation((Location)this.locationOfBucket.apply((Object)from.getBucket()));
        to.setType((Enum)StorageType.BLOB);
        to.setSize(from.getContentMetadata().getContentLength());
        to.setTier((from.getStorageClass() == null ? ObjectMetadata.StorageClass.STANDARD : from.getStorageClass()).toTier());
        return to;
    }
}

