/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.aws.filters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.TreeMultimap;
import com.google.common.io.BaseEncoding;
import com.google.common.io.ByteProcessor;
import com.google.common.io.ByteStreams;
import com.google.inject.ImplementedBy;
import java.io.InputStream;
import java.util.Comparator;
import java.util.Set;
import javax.annotation.Resource;
import javax.crypto.Mac;
import javax.inject.Inject;
import javax.inject.Named;
import org.jclouds.aws.domain.SessionCredentials;
import org.jclouds.crypto.Crypto;
import org.jclouds.crypto.Macs;
import org.jclouds.date.TimeStamp;
import org.jclouds.domain.Credentials;
import org.jclouds.http.HttpException;
import org.jclouds.http.HttpRequest;
import org.jclouds.http.HttpRequestFilter;
import org.jclouds.http.HttpUtils;
import org.jclouds.http.internal.SignatureWire;
import org.jclouds.http.utils.Queries;
import org.jclouds.location.Provider;
import org.jclouds.logging.Logger;
import org.jclouds.rest.RequestSigner;
import org.jclouds.rest.annotations.ApiVersion;
import org.jclouds.util.Strings2;

@ImplementedBy(value=FormSignerV2.class)
public interface FormSigner
extends HttpRequestFilter {

    public static final class FormSignerV2
    implements FormSigner,
    RequestSigner {
        public static final Set<String> mandatoryParametersForSignature = ImmutableSet.of((Object)"Action", (Object)"SignatureMethod", (Object)"SignatureVersion", (Object)"Version");
        private final SignatureWire signatureWire;
        private final String apiVersion;
        private final Supplier<Credentials> creds;
        private final javax.inject.Provider<String> dateService;
        private final Crypto crypto;
        private final HttpUtils utils;
        @Resource
        @Named(value="jclouds.signature")
        private Logger signatureLog = Logger.NULL;
        private static final Comparator<String> actionFirstAccessKeyLast = new Comparator<String>(){
            static final int LEFT_IS_GREATER = 1;
            static final int RIGHT_IS_GREATER = -1;

            @Override
            public int compare(String left, String right) {
                if (left == right) {
                    return 0;
                }
                if ("Action".equals(right) || "AWSAccessKeyId".equals(left)) {
                    return 1;
                }
                if ("Action".equals(left) || "AWSAccessKeyId".equals(right)) {
                    return -1;
                }
                return Ordering.natural().compare((Object)left, (Object)right);
            }
        };

        @Inject
        FormSignerV2(SignatureWire signatureWire, @ApiVersion String apiVersion, @Provider Supplier<Credentials> creds, @TimeStamp javax.inject.Provider<String> dateService, Crypto crypto, HttpUtils utils) {
            this.signatureWire = signatureWire;
            this.apiVersion = apiVersion;
            this.creds = creds;
            this.dateService = dateService;
            this.crypto = crypto;
            this.utils = utils;
        }

        public HttpRequest filter(HttpRequest request) throws HttpException {
            Preconditions.checkNotNull((Object)request.getFirstHeaderOrNull("Host"), (Object)"request is not ready to sign; host not present");
            Multimap decodedParams = (Multimap)Queries.queryParser().apply((Object)request.getPayload().getRawContent().toString());
            decodedParams.replaceValues((Object)"Version", (Iterable)ImmutableSet.of((Object)this.apiVersion));
            this.addSigningParams((Multimap<String, String>)decodedParams);
            this.validateParams((Multimap<String, String>)decodedParams);
            String stringToSign = this.createStringToSign(request, (Multimap<String, String>)decodedParams);
            String signature = this.sign(stringToSign);
            this.addSignature((Multimap<String, String>)decodedParams, signature);
            request = this.setPayload(request, (Multimap<String, String>)decodedParams);
            this.utils.logRequest(this.signatureLog, request, "<<");
            return request;
        }

        HttpRequest setPayload(HttpRequest request, Multimap<String, String> decodedParams) {
            String queryLine = FormSignerV2.buildQueryLine(decodedParams);
            request.setPayload(queryLine);
            request.getPayload().getContentMetadata().setContentType("application/x-www-form-urlencoded");
            return request;
        }

        private static String buildQueryLine(Multimap<String, String> decodedParams) {
            TreeMultimap sortedParams = TreeMultimap.create(actionFirstAccessKeyLast, (Comparator)Ordering.natural());
            sortedParams.putAll(decodedParams);
            return Queries.encodeQueryLine((Multimap)sortedParams);
        }

        @VisibleForTesting
        void validateParams(Multimap<String, String> params) {
            for (String parameter : mandatoryParametersForSignature) {
                Preconditions.checkState((boolean)params.containsKey((Object)parameter), (Object)("parameter " + parameter + " is required for signature"));
            }
        }

        @VisibleForTesting
        void addSignature(Multimap<String, String> params, String signature) {
            params.replaceValues((Object)"Signature", (Iterable)ImmutableList.of((Object)signature));
        }

        @VisibleForTesting
        public String sign(String toSign) {
            String signature;
            try {
                ByteProcessor hmacSHA256 = Macs.asByteProcessor((Mac)this.crypto.hmacSHA256(((Credentials)this.creds.get()).credential.getBytes(Charsets.UTF_8)));
                signature = BaseEncoding.base64().encode((byte[])ByteStreams.readBytes((InputStream)Strings2.toInputStream((String)toSign), (ByteProcessor)hmacSHA256));
                if (this.signatureWire.enabled()) {
                    this.signatureWire.input(Strings2.toInputStream((String)signature));
                }
            }
            catch (Exception e) {
                throw new HttpException("error signing request", (Throwable)e);
            }
            return signature;
        }

        @VisibleForTesting
        public String createStringToSign(HttpRequest request, Multimap<String, String> decodedParams) {
            this.utils.logRequest(this.signatureLog, request, ">>");
            StringBuilder stringToSign = new StringBuilder();
            stringToSign.append(request.getMethod()).append("\n");
            stringToSign.append(request.getFirstHeaderOrNull("Host").toLowerCase()).append("\n");
            stringToSign.append(request.getEndpoint().getPath()).append("\n");
            stringToSign.append(this.buildCanonicalizedString(decodedParams));
            if (this.signatureWire.enabled()) {
                this.signatureWire.output((Object)stringToSign.toString());
            }
            return stringToSign.toString();
        }

        @VisibleForTesting
        String buildCanonicalizedString(Multimap<String, String> decodedParams) {
            return Queries.encodeQueryLine((Multimap)TreeMultimap.create(decodedParams), (Iterable)ImmutableList.of());
        }

        @VisibleForTesting
        void addSigningParams(Multimap<String, String> params) {
            params.removeAll((Object)"Signature");
            params.removeAll((Object)"SecurityToken");
            Credentials current = (Credentials)this.creds.get();
            if (current instanceof SessionCredentials) {
                params.put((Object)"SecurityToken", (Object)((SessionCredentials)((Object)SessionCredentials.class.cast(current))).getSessionToken());
            }
            params.replaceValues((Object)"SignatureMethod", (Iterable)ImmutableList.of((Object)"HmacSHA256"));
            params.replaceValues((Object)"SignatureVersion", (Iterable)ImmutableList.of((Object)"2"));
            params.replaceValues((Object)"Timestamp", (Iterable)ImmutableList.of((Object)this.dateService.get()));
            params.replaceValues((Object)"AWSAccessKeyId", (Iterable)ImmutableList.of((Object)((Credentials)this.creds.get()).identity));
        }

        public String createStringToSign(HttpRequest input) {
            return this.createStringToSign(input, (Multimap<String, String>)((Multimap)Queries.queryParser().apply((Object)input.getPayload().getRawContent().toString())));
        }
    }
}

