/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.riot.writer;

import java.io.OutputStream;
import java.io.Writer;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.system.IRIResolver;
import org.apache.jena.riot.system.PrefixMap;
import org.apache.jena.riot.system.RiotLib;
import org.apache.jena.riot.writer.WriterGraphRIOTBase;
import org.apache.jena.sparql.util.Context;

public abstract class TurtleWriterBase
extends WriterGraphRIOTBase {
    @Override
    public Lang getLang() {
        return Lang.TURTLE;
    }

    @Override
    public void write(Writer out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = RiotLib.create(out);
        this.output$(iOut, graph, prefixMap, baseURI, context2);
    }

    @Override
    public void write(OutputStream out, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        IndentedWriter iOut = new IndentedWriter(out);
        this.output$(iOut, graph, prefixMap, baseURI, context2);
    }

    private void output$(IndentedWriter iOut, Graph graph, PrefixMap prefixMap, String baseURI, Context context2) {
        if (baseURI != null) {
            baseURI = IRIResolver.resolveStringSilent(baseURI);
        }
        this.output(iOut, graph, prefixMap, baseURI, context2);
        iOut.flush();
    }

    protected abstract void output(IndentedWriter var1, Graph var2, PrefixMap var3, String var4, Context var5);
}

