/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.ExecutionContext;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.engine.binding.BindingMap;
import org.apache.jena.sparql.engine.iterator.QueryIter;
import org.apache.jena.sparql.engine.iterator.QueryIterRepeatApply;
import org.apache.jena.sparql.serializer.SerializationContext;
import org.apache.jena.util.iterator.ClosableIterator;
import org.apache.jena.util.iterator.NiceIterator;

public class QueryIterTriplePattern
extends QueryIterRepeatApply {
    private final Triple pattern;
    static int countMapper = 0;

    public QueryIterTriplePattern(QueryIterator input, Triple pattern, ExecutionContext cxt) {
        super(input, cxt);
        this.pattern = pattern;
    }

    @Override
    protected QueryIterator nextStage(Binding binding) {
        return new TripleMapper(binding, this.pattern, this.getExecContext());
    }

    @Override
    protected void details(IndentedWriter out, SerializationContext sCxt) {
        out.print("QueryIterTriplePattern: " + this.pattern);
    }

    static class TripleMapper
    extends QueryIter {
        private Node s;
        private Node p;
        private Node o;
        private Binding binding;
        private ClosableIterator<Triple> graphIter;
        private Binding slot = null;
        private boolean finished = false;
        private volatile boolean cancelled = false;

        TripleMapper(Binding binding, Triple pattern, ExecutionContext cxt) {
            super(cxt);
            this.s = TripleMapper.substitute(pattern.getSubject(), binding);
            this.p = TripleMapper.substitute(pattern.getPredicate(), binding);
            this.o = TripleMapper.substitute(pattern.getObject(), binding);
            this.binding = binding;
            Node s2 = TripleMapper.tripleNode(this.s);
            Node p2 = TripleMapper.tripleNode(this.p);
            Node o2 = TripleMapper.tripleNode(this.o);
            Graph graph = cxt.getActiveGraph();
            this.graphIter = graph.find(s2, p2, o2);
        }

        private static Node tripleNode(Node node) {
            if (node.isVariable()) {
                return Node.ANY;
            }
            return node;
        }

        private static Node substitute(Node node, Binding binding) {
            Node x;
            if (Var.isVar(node) && (x = binding.get(Var.alloc(node))) != null) {
                return x;
            }
            return node;
        }

        private Binding mapper(Triple r) {
            BindingMap results = BindingFactory.create(this.binding);
            if (!TripleMapper.insert(this.s, r.getSubject(), results)) {
                return null;
            }
            if (!TripleMapper.insert(this.p, r.getPredicate(), results)) {
                return null;
            }
            if (!TripleMapper.insert(this.o, r.getObject(), results)) {
                return null;
            }
            return results;
        }

        private static boolean insert(Node inputNode, Node outputNode, BindingMap results) {
            if (!Var.isVar(inputNode)) {
                return true;
            }
            Var v = Var.alloc(inputNode);
            Node x = results.get(v);
            if (x != null) {
                return outputNode.equals((Object)x);
            }
            results.add(v, outputNode);
            return true;
        }

        @Override
        protected boolean hasNextBinding() {
            if (this.finished) {
                return false;
            }
            if (this.slot != null) {
                return true;
            }
            if (this.cancelled) {
                this.graphIter.close();
                this.finished = true;
                return false;
            }
            while (this.graphIter.hasNext() && this.slot == null) {
                Triple t = (Triple)this.graphIter.next();
                this.slot = this.mapper(t);
            }
            if (this.slot == null) {
                this.finished = true;
            }
            return this.slot != null;
        }

        @Override
        protected Binding moveToNextBinding() {
            if (!this.hasNextBinding()) {
                throw new ARQInternalErrorException();
            }
            Binding r = this.slot;
            this.slot = null;
            return r;
        }

        @Override
        protected void closeIterator() {
            if (this.graphIter != null) {
                NiceIterator.close(this.graphIter);
            }
            this.graphIter = null;
        }

        @Override
        protected void requestCancel() {
            this.cancelled = true;
        }
    }
}

