/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.engine.iterator;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.atlas.io.IndentedWriter;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.engine.iterator.QueryIteratorWrapper;
import org.apache.jena.sparql.serializer.SerializationContext;

public class QueryIteratorCaching
extends QueryIteratorWrapper {
    List<Binding> cache = new ArrayList<Binding>();

    public QueryIteratorCaching(QueryIterator qIter) {
        super(qIter);
    }

    @Override
    protected Binding moveToNextBinding() {
        Binding b = super.moveToNextBinding();
        this.cache.add(b);
        return b;
    }

    @Override
    public void output(IndentedWriter out, SerializationContext sCxt) {
    }

    public QueryIteratorCaching createRepeat() {
        List<Binding> elements = this.cache;
        if (super.hasNext()) {
            elements = new ArrayList<Binding>(this.cache);
        }
        return new QueryIteratorCaching(new QueryIterPlainWrapper(elements.iterator(), null));
    }

    public static QueryIterator reset(QueryIterator qIter) {
        if (qIter instanceof QueryIteratorCaching) {
            QueryIteratorCaching cIter = (QueryIteratorCaching)qIter;
            return cIter.createRepeat();
        }
        return qIter;
    }
}

