/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.sparql.expr.nodevalue;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.datatype.DatatypeConstants;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.atlas.lib.StrUtils;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.datatypes.RDFDatatype;
import org.apache.jena.datatypes.xsd.XSDDatatype;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.rdf.model.impl.Util;
import org.apache.jena.sparql.ARQInternalErrorException;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.expr.ExprEvalException;
import org.apache.jena.sparql.expr.ExprEvalTypeException;
import org.apache.jena.sparql.expr.NodeValue;
import org.apache.jena.sparql.expr.RegexJava;
import org.apache.jena.sparql.expr.ValueSpaceClassification;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.expr.nodevalue.NumericType;
import org.apache.jena.sparql.util.DateTimeStruct;

public class XSDFuncOp {
    private static final int DIVIDE_PRECISION = 24;
    private static Set<XSDDatatype> integerSubTypes = new HashSet<XSDDatatype>();
    public static final String defaultTimezone = "Z";
    private static int F_UNDEF;
    private static Duration zeroDuration;

    private XSDFuncOp() {
    }

    public static NodeValue numAdd(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("add", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().add(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().add(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() + nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() + nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue numSubtract(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("subtract", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().subtract(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().subtract(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() - nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() - nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue numMultiply(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("multiply", nv1, nv2)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv1.getInteger().multiply(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv1.getDecimal().multiply(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() * nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() * nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static NodeValue numDivide(NodeValue nv1, NodeValue nv2) {
        switch (XSDFuncOp.classifyNumeric("divide", nv1, nv2)) {
            case OP_INTEGER: {
                if (nv2.getInteger().equals(BigInteger.ZERO)) {
                    throw new ExprEvalException("Divide by zero in divide");
                }
                BigDecimal d1 = new BigDecimal(nv1.getInteger());
                BigDecimal d2 = new BigDecimal(nv2.getInteger());
                return XSDFuncOp.decimalDivide(d1, d2);
            }
            case OP_DECIMAL: {
                if (nv2.getDecimal().compareTo(BigDecimal.ZERO) == 0) {
                    throw new ExprEvalException("Divide by zero in decimal divide");
                }
                BigDecimal d1 = nv1.getDecimal();
                BigDecimal d2 = nv2.getDecimal();
                return XSDFuncOp.decimalDivide(d1, d2);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(nv1.getFloat() / nv2.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(nv1.getDouble() / nv2.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    private static NodeValue decimalDivide(BigDecimal d1, BigDecimal d2) {
        try {
            BigDecimal d3 = d1.divide(d2, 24, 3);
            return XSDFuncOp.messAroundWithBigDecimalFormat(d3);
        }
        catch (ArithmeticException ex) {
            Log.warn(XSDFuncOp.class, (String)"ArithmeticException in decimal divide - attempting to treat as doubles");
            BigDecimal d3 = new BigDecimal(d1.doubleValue() / d2.doubleValue());
            return NodeValue.makeDecimal(d3);
        }
    }

    private static NodeValue messAroundWithBigDecimalFormat(BigDecimal d) {
        int i;
        String x = d.toPlainString();
        int dotIdx = x.indexOf(46);
        if (dotIdx < 0) {
            return NodeValue.makeNode(x, (RDFDatatype)XSDDatatype.XSDdecimal);
        }
        for (i = x.length() - 1; i > dotIdx + 1 && x.charAt(i) == '0'; --i) {
        }
        if (i < x.length() - 1) {
            x = x.substring(0, i + 1);
        }
        return NodeValue.makeNode(x, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue max(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == -1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue min(NodeValue nv1, NodeValue nv2) {
        int x = XSDFuncOp.compareNumeric(nv1, nv2);
        if (x == 1) {
            return nv2;
        }
        return nv1;
    }

    public static NodeValue not(NodeValue nv) {
        boolean b = XSDFuncOp.booleanEffectiveValue(nv);
        return NodeValue.booleanReturn(!b);
    }

    public static NodeValue booleanEffectiveValueAsNodeValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv;
        }
        return NodeValue.booleanReturn(XSDFuncOp.booleanEffectiveValue(nv));
    }

    public static boolean booleanEffectiveValue(NodeValue nv) {
        if (nv.isBoolean()) {
            return nv.getBoolean();
        }
        if (nv.isString() || nv.isLangString()) {
            return !nv.getString().isEmpty();
        }
        if (nv.isInteger()) {
            return !nv.getInteger().equals(NodeValue.IntegerZERO);
        }
        if (nv.isDecimal()) {
            return !nv.getDecimal().equals(NodeValue.DecimalZERO);
        }
        if (nv.isDouble()) {
            return nv.getDouble() != 0.0;
        }
        NodeValue.raise(new ExprEvalException("Not a boolean effective value (wrong type): " + nv));
        return false;
    }

    public static NodeValue unaryMinus(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("unaryMinus", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().negate());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().negate());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(-nv.getFloat());
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(-nv.getDouble());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue unaryPlus(NodeValue nv) {
        NumericType opType = XSDFuncOp.classifyNumeric("unaryPlus", nv);
        return nv;
    }

    public static NodeValue abs(NodeValue nv) {
        switch (XSDFuncOp.classifyNumeric("abs", nv)) {
            case OP_INTEGER: {
                return NodeValue.makeInteger(nv.getInteger().abs());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(nv.getDecimal().abs());
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.abs(nv.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.abs(nv.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + nv);
    }

    public static NodeValue ceiling(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("ceiling", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 2);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat((float)Math.ceil(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.ceil(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue floor(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("floor", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                BigDecimal dec = v.getDecimal().setScale(0, 3);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat((float)Math.floor(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.floor(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue round(NodeValue v) {
        switch (XSDFuncOp.classifyNumeric("round", v)) {
            case OP_INTEGER: {
                return v;
            }
            case OP_DECIMAL: {
                int sgn = v.getDecimal().signum();
                BigDecimal dec = sgn < 0 ? v.getDecimal().setScale(0, 5) : v.getDecimal().setScale(0, 4);
                return NodeValue.makeDecimal(dec);
            }
            case OP_FLOAT: {
                return NodeValue.makeFloat(Math.round(v.getFloat()));
            }
            case OP_DOUBLE: {
                return NodeValue.makeDouble(Math.round(v.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    private static BigDecimal roundDecimalValue(BigDecimal dec, int precision, boolean isHalfToEven) {
        if (isHalfToEven) {
            return dec.setScale(precision, 6);
        }
        int sgn = dec.signum();
        if (sgn < 0) {
            return dec.setScale(precision, 5);
        }
        return dec.setScale(precision, 4);
    }

    public static NodeValue roundXpath3(NodeValue v, NodeValue precision, boolean isHalfEven) {
        if (!precision.isInteger()) {
            throw new ExprEvalTypeException("The precision for rounding should be an integer");
        }
        int precisionInt = precision.getInteger().intValue();
        String fName = isHalfEven ? "round-half-to-even" : "round";
        switch (XSDFuncOp.classifyNumeric(fName, v)) {
            case OP_INTEGER: {
                BigDecimal decFromInt = XSDFuncOp.roundDecimalValue(new BigDecimal(v.getInteger()), precisionInt, isHalfEven);
                return NodeValue.makeInteger(decFromInt.toBigIntegerExact());
            }
            case OP_DECIMAL: {
                return NodeValue.makeDecimal(XSDFuncOp.roundDecimalValue(v.getDecimal(), precisionInt, isHalfEven));
            }
            case OP_FLOAT: {
                BigDecimal decFromFloat = XSDFuncOp.roundDecimalValue(new BigDecimal(v.getFloat()), precisionInt, isHalfEven);
                return NodeValue.makeFloat(decFromFloat.floatValue());
            }
            case OP_DOUBLE: {
                BigDecimal decFromDouble = XSDFuncOp.roundDecimalValue(new BigDecimal(v.getDouble()), precisionInt, isHalfEven);
                return NodeValue.makeDouble(decFromDouble.doubleValue());
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : " + v);
    }

    public static NodeValue sqrt(NodeValue v) {
        return NodeValue.makeDouble(Math.sqrt(v.getDouble()));
    }

    public static NodeValue javaSubstring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.javaSubstring(v1, v2, null);
    }

    public static NodeValue javaSubstring(NodeValue nvString, NodeValue nvStart, NodeValue nvFinish) {
        try {
            String string = nvString.getString();
            int start = nvStart.getInteger().intValue();
            if (nvFinish == null) {
                return NodeValue.makeString(string.substring(start));
            }
            int finish = nvFinish.getInteger().intValue();
            return NodeValue.makeString(string.substring(start, string.offsetByCodePoints(start, finish - start)));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue javaSprintf(NodeValue nvFormat, List<NodeValue> valuesToPrint) {
        try {
            String formatForOutput = nvFormat.getString();
            ArrayList<Object> objVals = new ArrayList<Object>();
            block15: for (NodeValue nvValue : valuesToPrint) {
                ValueSpaceClassification vlSpClass = nvValue.getValueSpace();
                switch (vlSpClass) {
                    case VSPACE_NUM: {
                        NumericType type = XSDFuncOp.classifyNumeric("javaSprintf", nvValue);
                        switch (type) {
                            case OP_DECIMAL: {
                                objVals.add(nvValue.getDecimal());
                                break;
                            }
                            case OP_INTEGER: {
                                objVals.add(nvValue.getInteger());
                                break;
                            }
                            case OP_DOUBLE: {
                                objVals.add(nvValue.getDouble());
                                break;
                            }
                            case OP_FLOAT: {
                                objVals.add(Float.valueOf(nvValue.getFloat()));
                            }
                        }
                        continue block15;
                    }
                    case VSPACE_DATE: 
                    case VSPACE_DATETIME: {
                        XMLGregorianCalendar gregorianCalendarValue = nvValue.getDateTime();
                        objVals.add(gregorianCalendarValue.toGregorianCalendar().getTime());
                        continue block15;
                    }
                    case VSPACE_STRING: {
                        objVals.add(nvValue.getString());
                        continue block15;
                    }
                    case VSPACE_BOOLEAN: {
                        objVals.add(nvValue.getBoolean());
                        continue block15;
                    }
                    case VSPACE_LANG: {
                        objVals.add(nvValue.getLang());
                        continue block15;
                    }
                }
                objVals.add(NodeFunctions.str(nvValue));
            }
            return NodeValue.makeString(String.format(formatForOutput, objVals.toArray()));
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue strlen(NodeValue nvString) {
        Node n = NodeFunctions.checkAndGetStringLiteral("strlen", nvString);
        String str2 = n.getLiteralLexicalForm();
        int len = str2.codePointCount(0, str2.length());
        return NodeValue.makeInteger(len);
    }

    public static NodeValue strReplace(NodeValue nvStr, NodeValue nvPattern, NodeValue nvReplacement, NodeValue nvFlags) {
        String pat = NodeFunctions.checkAndGetStringLiteral("replace", nvPattern).getLiteralLexicalForm();
        String flagsStr = null;
        if (nvFlags != null) {
            flagsStr = NodeFunctions.checkAndGetStringLiteral("replace", nvFlags).getLiteralLexicalForm();
        }
        return XSDFuncOp.strReplace(nvStr, RegexJava.makePattern("replace", pat, flagsStr), nvReplacement);
    }

    public static NodeValue strReplace(NodeValue nvStr, Pattern pattern, NodeValue nvReplacement) {
        String n = NodeFunctions.checkAndGetStringLiteral("replace", nvStr).getLiteralLexicalForm();
        String rep = NodeFunctions.checkAndGetStringLiteral("replace", nvReplacement).getLiteralLexicalForm();
        String x = XSDFuncOp.replaceAll(pattern.matcher(n), rep);
        if (x == null) {
            return nvStr;
        }
        return XSDFuncOp.calcReturn(x, nvStr.asNode());
    }

    private static String replaceAll(Matcher matcher, String rep) {
        try {
            StringBuffer sb = null;
            while (matcher.find()) {
                if (sb == null) {
                    sb = new StringBuffer();
                } else if (matcher.start() == matcher.end()) continue;
                matcher.appendReplacement(sb, rep);
            }
            if (sb == null) {
                return null;
            }
            matcher.appendTail(sb);
            return sb.toString();
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    public static NodeValue strReplace(NodeValue nvStr, NodeValue nvPattern, NodeValue nvReplacement) {
        return XSDFuncOp.strReplace(nvStr, nvPattern, nvReplacement, null);
    }

    public static NodeValue substring(NodeValue v1, NodeValue v2) {
        return XSDFuncOp.substring(v1, v2, null);
    }

    public static NodeValue substring(NodeValue nvString, NodeValue nvStart, NodeValue nvLength) {
        Node n = NodeFunctions.checkAndGetStringLiteral("substring", nvString);
        RDFDatatype dt = n.getLiteralDatatype();
        String lang = n.getLiteralLanguage();
        try {
            int length;
            String string = n.getLiteralLexicalForm();
            int start = XSDFuncOp.intValueStr(nvStart, string.length() + 1);
            if (nvLength != null) {
                length = XSDFuncOp.intValueStr(nvLength, 0);
            } else {
                length = string.length();
                if (start < 0) {
                    length -= start;
                }
            }
            int finish = start + length;
            if (start <= 0) {
                start = 1;
            }
            --start;
            if (--finish > string.length()) {
                finish = string.length();
            }
            if (finish < start) {
                finish = start;
            }
            if (finish < 0) {
                finish = 0;
            }
            if (string.length() == 0) {
                return XSDFuncOp.calcReturn("", n);
            }
            String lex2 = string.substring(start, string.offsetByCodePoints(start, finish - start));
            return XSDFuncOp.calcReturn(lex2, n);
        }
        catch (IndexOutOfBoundsException ex) {
            throw new ExprEvalException("IndexOutOfBounds", ex);
        }
    }

    private static int intValueStr(NodeValue nv, int valueNan) {
        if (nv.isInteger()) {
            return nv.getInteger().intValue();
        }
        if (nv.isDecimal()) {
            return (int)Math.round(nv.getDecimal().doubleValue());
        }
        if (nv.isFloat()) {
            float f = nv.getFloat();
            if (Float.isNaN(f)) {
                return valueNan;
            }
            return Math.round(f);
        }
        if (nv.isDouble()) {
            double d = nv.getDouble();
            if (Double.isNaN(d)) {
                return valueNan;
            }
            return (int)Math.round(d);
        }
        throw new ExprEvalException("Not a number:" + nv);
    }

    public static NodeValue strContains(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("contains", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        boolean x = StrUtils.contains((String)lex1, (String)lex2);
        return NodeValue.booleanReturn(x);
    }

    public static NodeValue strStartsWith(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strStarts", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        return NodeValue.booleanReturn(lex1.startsWith(lex2));
    }

    public static NodeValue strEndsWith(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strEnds", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        return NodeValue.booleanReturn(lex1.endsWith(lex2));
    }

    private static NodeValue calcReturn(String result, Node arg) {
        Node n2 = NodeFactory.createLiteral((String)result, (String)arg.getLiteralLanguage(), (RDFDatatype)arg.getLiteralDatatype());
        return NodeValue.makeNode(n2);
    }

    public static NodeValue strBefore(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strBefore", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        Node mainArg = string.asNode();
        if (lex2.length() == 0) {
            return XSDFuncOp.calcReturn("", mainArg);
        }
        int i = lex1.indexOf(lex2);
        if (i < 0) {
            return NodeValue.nvEmptyString;
        }
        String s = lex1.substring(0, i);
        return XSDFuncOp.calcReturn(s, string.asNode());
    }

    public static NodeValue strAfter(NodeValue string, NodeValue match) {
        NodeFunctions.checkTwoArgumentStringLiterals("strAfter", string, match);
        String lex1 = string.asNode().getLiteralLexicalForm();
        String lex2 = match.asNode().getLiteralLexicalForm();
        Node mainArg = string.asNode();
        if (lex2.length() == 0) {
            return XSDFuncOp.calcReturn(lex1, mainArg);
        }
        int i = lex1.indexOf(lex2);
        if (i < 0) {
            return NodeValue.nvEmptyString;
        }
        String s = lex1.substring(i += lex2.length());
        return XSDFuncOp.calcReturn(s, string.asNode());
    }

    public static NodeValue strLowerCase(NodeValue string) {
        Node n = NodeFunctions.checkAndGetStringLiteral("lcase", string);
        String lex = n.getLiteralLexicalForm();
        String lex2 = lex.toLowerCase();
        return XSDFuncOp.calcReturn(lex2, string.asNode());
    }

    public static NodeValue strUpperCase(NodeValue string) {
        Node n = NodeFunctions.checkAndGetStringLiteral("ucase", string);
        String lex = n.getLiteralLexicalForm();
        String lex2 = lex.toUpperCase();
        return XSDFuncOp.calcReturn(lex2, string.asNode());
    }

    public static NodeValue strEncodeForURI(NodeValue v) {
        Node n = v.asNode();
        if (!n.isLiteral()) {
            throw new ExprEvalException("Not a literal");
        }
        if (!Util.isSimpleString((Node)n) && !Util.isLangString((Node)n)) {
            throw new ExprEvalException("Not a string literal");
        }
        String str2 = n.getLiteralLexicalForm();
        String encStr = IRILib.encodeUriComponent((String)str2);
        encStr = IRILib.encodeNonASCII((String)encStr);
        return NodeValue.makeString(encStr);
    }

    public static NodeValue fnConcat(List<NodeValue> args) {
        StringBuilder sb = new StringBuilder();
        for (NodeValue arg : args) {
            String x = arg.asString();
            sb.append(x);
        }
        return NodeValue.makeString(sb.toString());
    }

    public static NodeValue strConcat(List<NodeValue> args) {
        String lang = null;
        boolean mixedLang = false;
        boolean xsdString = false;
        boolean simpleLiteral = false;
        StringBuilder sb = new StringBuilder();
        for (NodeValue nv : args) {
            Node n = NodeFunctions.checkAndGetStringLiteral("CONCAT", nv);
            String lang1 = n.getLiteralLanguage();
            if (!lang1.equals("")) {
                if (lang != null && !lang1.equals(lang)) {
                    mixedLang = true;
                }
                lang = lang1;
            } else if (n.getLiteralDatatype() != null) {
                xsdString = true;
            } else {
                simpleLiteral = true;
            }
            sb.append(n.getLiteralLexicalForm());
        }
        if (mixedLang) {
            return NodeValue.makeString(sb.toString());
        }
        if (lang != null) {
            if (!xsdString && !simpleLiteral) {
                return NodeValue.makeNode(sb.toString(), lang, (String)null);
            }
            return NodeValue.makeString(sb.toString());
        }
        if (simpleLiteral && xsdString) {
            return NodeValue.makeString(sb.toString());
        }
        if (xsdString) {
            return NodeValue.makeNode(sb.toString(), (RDFDatatype)XSDDatatype.XSDstring);
        }
        if (simpleLiteral) {
            return NodeValue.makeString(sb.toString());
        }
        return NodeValue.makeString(sb.toString());
    }

    public static NodeValue strNormalizeSpace(NodeValue v) {
        String str2 = v.asString();
        if (str2 == "") {
            return NodeValue.nvEmptyString;
        }
        str2 = str2.trim().replaceAll("\\s+", " ");
        return NodeValue.makeString(str2);
    }

    public static NodeValue strNormalizeUnicode(NodeValue v1, NodeValue v2) {
        String normalizationFormStr = "nfc";
        if (v2 != null) {
            normalizationFormStr = v2.asNode().getLiteralLexicalForm().toLowerCase();
        }
        String inputString = v1.asString();
        if (normalizationFormStr.isEmpty()) {
            return NodeValue.makeString(inputString);
        }
        Normalizer.Form normalizationForm = Normalizer.Form.NFC;
        switch (normalizationFormStr) {
            case "nfd": {
                normalizationForm = Normalizer.Form.NFD;
                break;
            }
            case "nfkd": {
                normalizationForm = Normalizer.Form.NFKD;
                break;
            }
            case "nfkc": {
                normalizationForm = Normalizer.Form.NFKC;
                break;
            }
            case "nfc": {
                normalizationForm = Normalizer.Form.NFC;
                break;
            }
            case "fully-normalized": {
                throw new ExprEvalTypeException("The fully-normalized normalization form is not supported.");
            }
            default: {
                throw new ExprEvalTypeException("Unrecognized normalization form " + normalizationFormStr + ". Supported normalization forms: NFC,NFD,NFKD and NFKC.");
            }
        }
        return NodeValue.makeString(Normalizer.normalize(inputString, normalizationForm));
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv1, NodeValue nv2) {
        if (!nv1.isNumber()) {
            throw new ExprEvalTypeException("Not a number (first arg to " + fName + "): " + nv1);
        }
        if (!nv2.isNumber()) {
            throw new ExprEvalTypeException("Not a number (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isInteger()) {
            if (nv2.isInteger()) {
                return NumericType.OP_INTEGER;
            }
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDecimal()) {
            if (nv2.isDecimal()) {
                return NumericType.OP_DECIMAL;
            }
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isFloat()) {
            if (nv2.isFloat()) {
                return NumericType.OP_FLOAT;
            }
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        if (nv1.isDouble()) {
            if (nv2.isDouble()) {
                return NumericType.OP_DOUBLE;
            }
            throw new ARQInternalErrorException("Numeric op unrecognized (second arg to " + fName + "): " + nv2);
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (first arg to " + fName + "): " + nv1);
    }

    public static NumericType classifyNumeric(String fName, NodeValue nv) {
        if (!nv.isNumber()) {
            throw new ExprEvalTypeException("Not a number: (" + fName + ") " + nv);
        }
        if (nv.isInteger()) {
            return NumericType.OP_INTEGER;
        }
        if (nv.isDecimal()) {
            return NumericType.OP_DECIMAL;
        }
        if (nv.isFloat()) {
            return NumericType.OP_FLOAT;
        }
        if (nv.isDouble()) {
            return NumericType.OP_DOUBLE;
        }
        throw new ARQInternalErrorException("Numeric op unrecognized (" + fName + "): " + nv);
    }

    public static boolean isNumericType(XSDDatatype xsdDatatype) {
        if (XSDDatatype.XSDfloat.equals(xsdDatatype)) {
            return true;
        }
        if (XSDDatatype.XSDdouble.equals(xsdDatatype)) {
            return true;
        }
        return XSDFuncOp.isDecimalType(xsdDatatype);
    }

    public static boolean isDecimalType(XSDDatatype xsdDatatype) {
        if (XSDDatatype.XSDdecimal.equals(xsdDatatype)) {
            return true;
        }
        return XSDFuncOp.isIntegerType(xsdDatatype);
    }

    public static boolean isIntegerType(XSDDatatype xsdDatatype) {
        return integerSubTypes.contains(xsdDatatype);
    }

    private static int calcReturn(int x) {
        if (x < 0) {
            return -1;
        }
        if (x > 0) {
            return 1;
        }
        return 0;
    }

    public static int compareNumeric(NodeValue nv1, NodeValue nv2) {
        NumericType opType = XSDFuncOp.classifyNumeric("compareNumeric", nv1, nv2);
        switch (opType) {
            case OP_INTEGER: {
                return XSDFuncOp.calcReturn(nv1.getInteger().compareTo(nv2.getInteger()));
            }
            case OP_DECIMAL: {
                return XSDFuncOp.calcReturn(nv1.getDecimal().compareTo(nv2.getDecimal()));
            }
            case OP_FLOAT: {
                return XSDFuncOp.calcReturn(Float.compare(nv1.getFloat(), nv2.getFloat()));
            }
            case OP_DOUBLE: {
                return XSDFuncOp.calcReturn(Double.compare(nv1.getDouble(), nv2.getDouble()));
            }
        }
        throw new ARQInternalErrorException("Unrecognized numeric operation : (" + nv1 + " ," + nv2 + ")");
    }

    public static int compareString(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.calcReturn(nv1.getString().compareTo(nv2.getString()));
    }

    public static int compareDateTime(NodeValue nv1, NodeValue nv2) {
        if (SystemARQ.StrictDateTimeFO) {
            return XSDFuncOp.compareDateTimeFO(nv1, nv2);
        }
        return XSDFuncOp.compareXSDDateTime(nv1.getDateTime(), nv2.getDateTime());
    }

    public static int compareDuration(NodeValue nv1, NodeValue nv2) {
        return XSDFuncOp.compareDuration(nv1.getDuration(), nv2.getDuration());
    }

    private static int compareDateTimeFO(NodeValue nv1, NodeValue nv2) {
        XMLGregorianCalendar dt2;
        XMLGregorianCalendar dt1 = nv1.getDateTime();
        int x = XSDFuncOp.compareXSDDateTime(dt1, dt2 = nv2.getDateTime());
        if (x == 2) {
            NodeValue nv3;
            NodeValue nodeValue = nv3 = nv1.isDate() ? XSDFuncOp.fixupDate(nv1) : XSDFuncOp.fixupDateTime(nv1);
            if (nv3 != null) {
                XMLGregorianCalendar dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt3, dt2);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            NodeValue nodeValue2 = nv3 = nv2.isDate() ? XSDFuncOp.fixupDate(nv2) : XSDFuncOp.fixupDateTime(nv2);
            if (nv3 != null) {
                XMLGregorianCalendar dt3 = nv3.getDateTime();
                x = XSDFuncOp.compareXSDDateTime(dt1, dt3);
                if (x == 2) {
                    throw new ARQInternalErrorException("Still get indeterminate comparison");
                }
                return x;
            }
            throw new ARQInternalErrorException("Failed to fixup dateTimes");
        }
        return x;
    }

    private static NodeValue fixupDateOrDateTime(NodeValue nv) {
        if (nv.isDateTime()) {
            return XSDFuncOp.fixupDateTime(nv);
        }
        if (nv.isDate()) {
            return XSDFuncOp.fixupDate(nv);
        }
        throw new ARQInternalErrorException("Attempt to fixupDateOrDateTime on " + nv);
    }

    private static NodeValue fixupDateTime(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDateTime(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDateTime(dts.toString());
        if (!nv.isDateTime()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:dateTime");
        }
        return nv;
    }

    private static NodeValue fixupDate(NodeValue nv) {
        DateTimeStruct dts = DateTimeStruct.parseDate(nv.asNode().getLiteralLexicalForm());
        if (dts.timezone != null) {
            return null;
        }
        dts.timezone = defaultTimezone;
        nv = NodeValue.makeDate(dts.toString());
        if (!nv.isDate()) {
            throw new ARQInternalErrorException("Failed to reform an xsd:date");
        }
        return nv;
    }

    private static int compareXSDDateTime(XMLGregorianCalendar dt1, XMLGregorianCalendar dt2) {
        int x = dt1.compare(dt2);
        return XSDFuncOp.convertComparison(x);
    }

    private static int compareDuration(Duration duration1, Duration duration2) {
        int x = duration1.compare(duration2);
        return XSDFuncOp.convertComparison(x);
    }

    private static int convertComparison(int x) {
        if (x == 0) {
            return 0;
        }
        if (x == -1) {
            return -1;
        }
        if (x == 1) {
            return 1;
        }
        if (x == 2) {
            return 2;
        }
        throw new ARQInternalErrorException("Unexpected return from XSDDuration.compare: " + x);
    }

    public static int compareBoolean(NodeValue nv1, NodeValue nv2) {
        boolean b2;
        boolean b1 = nv1.getBoolean();
        if (b1 == (b2 = nv2.getBoolean())) {
            return 0;
        }
        if (!b1 && b2) {
            return -1;
        }
        if (b1 && !b2) {
            return 1;
        }
        throw new ARQInternalErrorException("Weird boolean comparison: " + nv1 + ", " + nv2);
    }

    public static boolean dateTimeCastCompatible(NodeValue nv, XSDDatatype xsd) {
        return nv.hasDateTime();
    }

    public static NodeValue dateTimeCast(NodeValue nv, String typeURI) {
        RDFDatatype t = NodeFactory.getType((String)typeURI);
        return XSDFuncOp.dateTimeCast(nv, t);
    }

    public static NodeValue dateTimeCast(NodeValue nv, RDFDatatype rdfDatatype) {
        if (!(rdfDatatype instanceof XSDDatatype)) {
            throw new ExprEvalTypeException("Can't cast to XSDDatatype: " + nv);
        }
        XSDDatatype xsd = (XSDDatatype)rdfDatatype;
        return XSDFuncOp.dateTimeCast(nv, xsd);
    }

    private static String tzStrFromNV(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
        if (dts == null) {
            return "";
        }
        String tzStr = dts.timezone;
        if (tzStr == null) {
            tzStr = "";
        }
        return tzStr;
    }

    public static NodeValue dateTimeCast(NodeValue nv, XSDDatatype xsd) {
        if (nv.isString()) {
            String s = nv.getString();
            if (!xsd.isValid(s)) {
                throw new ExprEvalTypeException("Invalid lexical form: '" + s + "' for " + xsd.getURI());
            }
            return NodeValue.makeNode(s, (RDFDatatype)xsd);
        }
        if (!nv.hasDateTime()) {
            throw new ExprEvalTypeException("Not a date/time type: " + nv);
        }
        XMLGregorianCalendar xsdDT = nv.getDateTime();
        if (XSDDatatype.XSDdateTime.equals(xsd)) {
            if (nv.isDateTime()) {
                return nv;
            }
            if (!nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:dateTime: " + nv);
            }
            String tzStr = XSDFuncOp.tzStrFromNV(nv);
            String x = String.format("%04d-%02d-%02dT00:00:00%s", xsdDT.getYear(), xsdDT.getMonth(), xsdDT.getDay(), tzStr);
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDdate.equals(xsd)) {
            if (nv.isDate()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:date: " + nv);
            }
            String tzStr = XSDFuncOp.tzStrFromNV(nv);
            String x = String.format("%04d-%02d-%02d%s", xsdDT.getYear(), xsdDT.getMonth(), xsdDT.getDay(), tzStr);
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDtime.equals(xsd)) {
            if (nv.isTime()) {
                return nv;
            }
            if (!nv.isDateTime()) {
                throw new ExprEvalTypeException("Can't cast to XSD:time: " + nv);
            }
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            if (dts.timezone == null) {
                dts.timezone = "";
            }
            String x = String.format("%s:%s:%s%s", dts.hour, dts.minute, dts.second, dts.timezone);
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDgYear.equals(xsd)) {
            if (nv.isGYear()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYear: " + nv);
            }
            String x = String.format("%04d", xsdDT.getYear());
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDgYearMonth.equals(xsd)) {
            if (nv.isGYearMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gYearMonth: " + nv);
            }
            String x = String.format("%04d-%02d", xsdDT.getYear(), xsdDT.getMonth());
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDgMonth.equals(xsd)) {
            if (nv.isGMonth()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonth: " + nv);
            }
            String x = String.format("--%02d", xsdDT.getMonth());
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDgMonthDay.equals(xsd)) {
            if (nv.isGMonthDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gMonthDay: " + nv);
            }
            String x = String.format("--%02d-%02d", xsdDT.getMonth(), xsdDT.getDay());
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        if (XSDDatatype.XSDgDay.equals(xsd)) {
            if (nv.isGDay()) {
                return nv;
            }
            if (!nv.isDateTime() && !nv.isDate()) {
                throw new ExprEvalTypeException("Can't cast to XSD:gDay: " + nv);
            }
            String x = String.format("---%02d", xsdDT.getDay());
            return NodeValue.makeNode(x, (RDFDatatype)xsd);
        }
        throw new ExprEvalTypeException("Can't case to <" + xsd.getURI() + ">: " + nv);
    }

    public static NodeValue getYear(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetYears(nv);
        }
        return XSDFuncOp.dtGetYear(nv);
    }

    public static NodeValue getMonth(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetMonths(nv);
        }
        return XSDFuncOp.dtGetMonth(nv);
    }

    public static NodeValue getDay(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetDays(nv);
        }
        return XSDFuncOp.dtGetDay(nv);
    }

    public static NodeValue getHours(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetHours(nv);
        }
        return XSDFuncOp.dtGetHours(nv);
    }

    public static NodeValue getMinutes(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetMinutes(nv);
        }
        return XSDFuncOp.dtGetMinutes(nv);
    }

    public static NodeValue getSeconds(NodeValue nv) {
        if (nv.isDuration()) {
            return XSDFuncOp.durGetSeconds(nv);
        }
        return XSDFuncOp.dtGetSeconds(nv);
    }

    public static NodeValue dtDateTime(NodeValue nv1, NodeValue nv2) {
        if (!nv1.isDate()) {
            throw new ExprEvalException("fn:dateTime: arg1: Not an xsd:date: " + nv1);
        }
        if (!nv2.isTime()) {
            throw new ExprEvalException("fn:dateTime: arg2: Not an xsd:time: " + nv2);
        }
        String lex1 = nv1.asNode().getLiteralLexicalForm();
        String lex2 = nv2.asNode().getLiteralLexicalForm();
        DateTimeStruct dts1 = DateTimeStruct.parseDate(lex1);
        DateTimeStruct dts2 = DateTimeStruct.parseTime(lex2);
        if (dts1.hasTimezone() && dts2.hasTimezone() && !Objects.equals(dts1.timezone, dts2.timezone)) {
            throw new ExprEvalException("fn:dateTime: Two different timezones: (" + nv1 + ", " + nv2 + ")");
        }
        dts2.year = dts1.year;
        dts2.month = dts1.month;
        dts2.day = dts1.day;
        dts2.timezone = dts1.timezone != null ? dts1.timezone : dts2.timezone;
        String lex = dts2.toString();
        return NodeValue.makeDateTime(lex);
    }

    public static NodeValue dtGetYear(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGYear() || nv.isGYearMonth()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.year, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a year datatype");
    }

    public static NodeValue dtGetMonth(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGYearMonth() || nv.isGMonth() || nv.isGMonthDay()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.month, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a month datatype");
    }

    public static NodeValue dtGetDay(NodeValue nv) {
        if (nv.isDateTime() || nv.isDate() || nv.isGMonthDay() || nv.isGDay()) {
            DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
            return NodeValue.makeNode(dts.day, (RDFDatatype)XSDDatatype.XSDinteger);
        }
        throw new ExprEvalException("Not a month datatype");
    }

    private static DateTimeStruct parseAnyDT(NodeValue nv) {
        String lex = nv.asNode().getLiteralLexicalForm();
        if (nv.isDateTime()) {
            return DateTimeStruct.parseDateTime(lex);
        }
        if (nv.isDate()) {
            return DateTimeStruct.parseDate(lex);
        }
        if (nv.isGYear()) {
            return DateTimeStruct.parseGYear(lex);
        }
        if (nv.isGYearMonth()) {
            return DateTimeStruct.parseGYearMonth(lex);
        }
        if (nv.isGMonth()) {
            return DateTimeStruct.parseGMonth(lex);
        }
        if (nv.isGMonthDay()) {
            return DateTimeStruct.parseGMonthDay(lex);
        }
        if (nv.isGDay()) {
            return DateTimeStruct.parseGDay(lex);
        }
        if (nv.isTime()) {
            return DateTimeStruct.parseTime(lex);
        }
        return null;
    }

    private static DateTimeStruct parseTime(NodeValue nv) {
        String lex = nv.asNode().getLiteralLexicalForm();
        if (nv.isDateTime()) {
            return DateTimeStruct.parseDateTime(lex);
        }
        if (nv.isTime()) {
            return DateTimeStruct.parseTime(lex);
        }
        throw new ExprEvalException("Not a datatype for time");
    }

    public static NodeValue dtGetHours(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.hour, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static NodeValue dtGetMinutes(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.minute, (RDFDatatype)XSDDatatype.XSDinteger);
    }

    public static NodeValue dtGetSeconds(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseTime(nv);
        return NodeValue.makeNode(dts.second, (RDFDatatype)XSDDatatype.XSDdecimal);
    }

    public static NodeValue dtGetTZ(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
        if (dts == null) {
            throw new ExprEvalException("Not a data/time value: " + nv);
        }
        if (dts.timezone == null) {
            return NodeValue.nvEmptyString;
        }
        return NodeValue.makeString(dts.timezone);
    }

    public static NodeValue dtGetTimezone(NodeValue nv) {
        DateTimeStruct dts = XSDFuncOp.parseAnyDT(nv);
        if (dts == null || dts.timezone == null) {
            throw new ExprEvalException("Not a datatype with a timezone: " + nv);
        }
        if ("".equals(dts.timezone)) {
            return null;
        }
        if (defaultTimezone.equals(dts.timezone)) {
            Node n = NodeFactory.createLiteral((String)"PT0S", (RDFDatatype)NodeFactory.getType((String)"http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        if ("+00:00".equals(dts.timezone)) {
            Node n = NodeFactory.createLiteral((String)"PT0S", (RDFDatatype)NodeFactory.getType((String)"http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        if ("-00:00".equals(dts.timezone)) {
            Node n = NodeFactory.createLiteral((String)"-PT0S", (RDFDatatype)NodeFactory.getType((String)"http://www.w3.org/2001/XMLSchema#dayTimeDuration"));
            return NodeValue.makeNode(n);
        }
        String s = dts.timezone;
        int idx = 0;
        StringBuilder sb = new StringBuilder();
        if (s.charAt(0) == '-') {
            sb.append('-');
        }
        sb.append("PT");
        XSDFuncOp.digitsTwo(s, ++idx, sb, 'H');
        idx += 2;
        XSDFuncOp.digitsTwo(s, ++idx, sb, 'M');
        idx += 2;
        return NodeValue.makeNode(sb.toString(), null, "http://www.w3.org/2001/XMLSchema#dayTimeDuration");
    }

    private static void digitsTwo(String s, int idx, StringBuilder sb, char indicator) {
        if (s.charAt(idx) == '0') {
            if (s.charAt(++idx) != '0') {
                sb.append(s.charAt(idx));
                sb.append(indicator);
            }
            ++idx;
        } else {
            sb.append(s.charAt(idx));
            sb.append(s.charAt(++idx));
            ++idx;
            sb.append(indicator);
        }
    }

    public static boolean isYearMonth(Duration dur) {
        return (dur.isSet(DatatypeConstants.YEARS) || dur.isSet(DatatypeConstants.MONTHS)) && !dur.isSet(DatatypeConstants.DAYS) && !dur.isSet(DatatypeConstants.HOURS) && !dur.isSet(DatatypeConstants.MINUTES) && !dur.isSet(DatatypeConstants.SECONDS);
    }

    public static boolean isDayTime(Duration dur) {
        return !dur.isSet(DatatypeConstants.YEARS) && !dur.isSet(DatatypeConstants.MONTHS) && (dur.isSet(DatatypeConstants.DAYS) || dur.isSet(DatatypeConstants.HOURS) || dur.isSet(DatatypeConstants.MINUTES) || dur.isSet(DatatypeConstants.SECONDS));
    }

    public static NodeValue durGetYears(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.YEARS);
    }

    public static NodeValue durGetMonths(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.MONTHS);
    }

    public static NodeValue durGetDays(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.DAYS);
    }

    public static NodeValue durGetHours(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.HOURS);
    }

    public static NodeValue durGetMinutes(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.MINUTES);
    }

    public static NodeValue durGetSeconds(NodeValue nv) {
        return XSDFuncOp.accessDuration(nv, DatatypeConstants.SECONDS);
    }

    public static NodeValue durGetSign(NodeValue nv) {
        int x = nv.getDuration().getSign();
        return NodeValue.makeInteger(x);
    }

    private static NodeValue accessDuration(NodeValue nv, DatatypeConstants.Field field) {
        Duration dur = XSDFuncOp.valueCanonicalDuration(nv);
        Number x = dur.getField(field);
        if (x == null) {
            Number number = x = field.equals(DatatypeConstants.SECONDS) ? BigDecimal.ZERO : BigInteger.ZERO;
        }
        if (field.equals(DatatypeConstants.SECONDS)) {
            return NodeValue.makeDecimal((BigDecimal)x);
        }
        return NodeValue.makeInteger((BigInteger)x);
    }

    private static Duration valueCanonicalDuration(NodeValue nv) {
        Duration dur = nv.getDuration();
        return dur;
    }

    public static NodeValue adjustDatetimeToTimezone(NodeValue nv1, NodeValue nv2) {
        if (nv1 == null) {
            return null;
        }
        if (!(nv1.isDateTime() || nv1.isDate() || nv1.isTime())) {
            throw new ExprEvalException("Not a valid date, datetime or time:" + nv1);
        }
        XMLGregorianCalendar calValue = nv1.getDateTime();
        Boolean hasTz = calValue.getTimezone() != Integer.MIN_VALUE;
        int inputOffset = 0;
        if (hasTz.booleanValue()) {
            inputOffset = calValue.getTimezone();
        }
        int tzOffset = 0;
        if (nv2 != null) {
            if (!nv2.isDuration()) {
                String nv2StrValue = nv2.getString();
                if (nv2StrValue.equals("")) {
                    calValue.setTimezone(Integer.MIN_VALUE);
                    if (nv1.isDateTime()) {
                        return NodeValue.makeDateTime(calValue);
                    }
                    if (nv1.isTime()) {
                        return NodeValue.makeNode(calValue.toXMLFormat(), (RDFDatatype)XSDDatatype.XSDtime);
                    }
                    return NodeValue.makeDate(calValue);
                }
                throw new ExprEvalException("Not a valid duration:" + nv2);
            }
            Duration tzDuration = nv2.getDuration();
            tzOffset = tzDuration.getSign() * (tzDuration.getMinutes() + 60 * tzDuration.getHours());
            if (tzDuration.getSeconds() > 0) {
                throw new ExprEvalException("The timezone duration should be an integral number of minutes");
            }
            int absTzOffset = Math.abs(tzOffset);
            if (absTzOffset > 840) {
                throw new ExprEvalException("The timezone should be a duration between -PT14H and PT14H.");
            }
        } else {
            tzOffset = TimeZone.getDefault().getOffset(new Date().getTime()) / 60000;
        }
        Duration durToAdd = NodeValue.xmlDatatypeFactory.newDurationDayTime(tzOffset - inputOffset > 0, 0, 0, Math.abs(tzOffset - inputOffset), 0);
        if (hasTz.booleanValue()) {
            calValue.add(durToAdd);
        }
        calValue.setTimezone(tzOffset);
        if (nv1.isDateTime()) {
            return NodeValue.makeDateTime(calValue);
        }
        if (nv1.isTime()) {
            return NodeValue.makeNode(calValue.toXMLFormat(), (RDFDatatype)XSDDatatype.XSDtime);
        }
        return NodeValue.makeDate(calValue);
    }

    public static NodeValue formatNumber(NodeValue nv, NodeValue picture, NodeValue nvLocale) {
        DecimalFormatSymbols dfs;
        if (!nv.isNumber()) {
            NodeValue.raise(new ExprEvalException("Not a number: " + nv));
        }
        if (!picture.isString()) {
            NodeValue.raise(new ExprEvalException("Not a string: " + picture));
        }
        if (nvLocale != null && !nvLocale.isString()) {
            NodeValue.raise(new ExprEvalException("Not a string: " + nvLocale));
        }
        Locale locale = Locale.ROOT;
        if (nvLocale != null) {
            locale = Locale.forLanguageTag(nvLocale.asString());
        }
        DecimalFormat formatter = (dfs = DecimalFormatSymbols.getInstance(locale)) == null ? new DecimalFormat(picture.getString()) : new DecimalFormat(picture.getString(), dfs);
        NumericType nt = XSDFuncOp.classifyNumeric("fn:formatNumber", nv);
        String s = null;
        switch (nt) {
            case OP_DECIMAL: 
            case OP_FLOAT: 
            case OP_DOUBLE: {
                s = formatter.format(nv.getDouble());
                break;
            }
            case OP_INTEGER: {
                s = formatter.format(nv.getInteger().longValue());
                break;
            }
        }
        return NodeValue.makeString(s);
    }

    static {
        integerSubTypes.add(XSDDatatype.XSDint);
        integerSubTypes.add(XSDDatatype.XSDlong);
        integerSubTypes.add(XSDDatatype.XSDshort);
        integerSubTypes.add(XSDDatatype.XSDbyte);
        integerSubTypes.add(XSDDatatype.XSDunsignedByte);
        integerSubTypes.add(XSDDatatype.XSDunsignedShort);
        integerSubTypes.add(XSDDatatype.XSDunsignedInt);
        integerSubTypes.add(XSDDatatype.XSDunsignedLong);
        integerSubTypes.add(XSDDatatype.XSDinteger);
        integerSubTypes.add(XSDDatatype.XSDnonPositiveInteger);
        integerSubTypes.add(XSDDatatype.XSDnonNegativeInteger);
        integerSubTypes.add(XSDDatatype.XSDpositiveInteger);
        integerSubTypes.add(XSDDatatype.XSDnegativeInteger);
        F_UNDEF = Integer.MIN_VALUE;
        zeroDuration = NodeValue.xmlDatatypeFactory.newDuration(0L);
    }
}

