/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.riot;

import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.riot.ParseForTest;
import org.apache.jena.arq.junit.riot.RiotTests;
import org.apache.jena.atlas.io.IO;
import org.apache.jena.atlas.lib.FileOps;
import org.apache.jena.atlas.lib.IRILib;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RiotException;
import org.apache.jena.riot.RiotNotFoundException;
import org.apache.jena.riot.system.StreamRDF;
import org.apache.jena.riot.system.StreamRDFLib;
import org.apache.jena.shared.NotFoundException;
import org.junit.Assert;

public class RiotSyntaxTest
implements Runnable {
    private final boolean expectLegalSyntax;
    private final ManifestEntry testEntry;
    private final Lang lang;
    private final String filename;

    public RiotSyntaxTest(ManifestEntry entry, Lang lang, boolean positiveTest) {
        this.testEntry = entry;
        this.expectLegalSyntax = positiveTest;
        this.filename = entry.getAction().getURI();
        this.lang = lang;
    }

    @Override
    public void run() {
        block5: {
            StreamRDF stream = StreamRDFLib.sinkNull();
            String fn = IRILib.IRIToFilename((String)this.filename);
            if (!FileOps.exists((String)fn)) {
                throw new NotFoundException("File not found: " + this.filename){

                    public Throwable fillInStackTrace() {
                        return this;
                    }
                };
            }
            try {
                ParseForTest.parse(stream, this.filename, this.lang, RiotTests.allowWarnings(this.testEntry));
                if (!this.expectLegalSyntax) {
                    String s = IO.readWholeFileAsUTF8((String)fn);
                    System.err.println();
                    System.err.println("== " + this.filename);
                    System.err.print(s);
                    Assert.fail((String)"Parsing succeeded in a bad syntax test");
                }
            }
            catch (RiotNotFoundException ex) {
                throw ex;
            }
            catch (RiotException ex) {
                if (!this.expectLegalSyntax) break block5;
                Assert.fail((String)("Parse error: " + ex.getMessage()));
            }
        }
    }
}

