/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.riot;

import java.util.HashSet;
import java.util.Set;
import org.apache.jena.arq.junit.LibTestSetup;
import org.apache.jena.arq.junit.SurpressedTest;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.riot.RiotEvalTest;
import org.apache.jena.arq.junit.riot.RiotSyntaxTest;
import org.apache.jena.arq.junit.riot.VocabLangRDF;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.riot.RiotException;
import org.apache.jena.vocabulary.RDF;

public class RiotTests {
    public static String assumedRootURIex = "http://example/base/";
    public static String assumedRootURITurtle = "http://www.w3.org/2013/TurtleTests/";
    public static String assumedRootURITriG = "http://www.w3.org/2013/TriGTests/";
    static Set<String> allowWarningSet = new HashSet<String>();

    public static Runnable makeRIOTTest(ManifestEntry entry) {
        Resource item = entry.getEntry();
        Object testName = entry.getName();
        Resource action = entry.getAction();
        Resource result = entry.getResult();
        String labelPrefix = "[RIOT]";
        try {
            Resource testType = LibTestSetup.getResource(item, RDF.type);
            if (testType == null) {
                throw new RiotException("Can't determine the test type");
            }
            if (labelPrefix != null) {
                testName = labelPrefix + (String)testName;
            }
            Resource input = action;
            Resource output = result;
            if (testType.equals((Object)VocabLangRDF.TestPositiveSyntaxTTL)) {
                return new RiotSyntaxTest(entry, RDFLanguages.TURTLE, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeSyntaxTTL)) {
                return new RiotSyntaxTest(entry, RDFLanguages.TURTLE, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestPositiveSyntaxTriG)) {
                return new RiotSyntaxTest(entry, RDFLanguages.TRIG, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeSyntaxTriG)) {
                return new RiotSyntaxTest(entry, RDFLanguages.TRIG, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestPositiveSyntaxNT)) {
                return new RiotSyntaxTest(entry, RDFLanguages.NTRIPLES, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeSyntaxNT)) {
                return new RiotSyntaxTest(entry, RDFLanguages.NTRIPLES, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestPositiveSyntaxNQ)) {
                return new RiotSyntaxTest(entry, RDFLanguages.NQUADS, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeSyntaxNQ)) {
                return new RiotSyntaxTest(entry, RDFLanguages.NQUADS, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestPositiveSyntaxRJ)) {
                return new RiotSyntaxTest(entry, RDFLanguages.RDFJSON, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeSyntaxRJ)) {
                return new RiotSyntaxTest(entry, RDFLanguages.RDFJSON, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestSurpressed)) {
                return new SurpressedTest(entry);
            }
            if (testType.equals((Object)VocabLangRDF.TestEvalTTL)) {
                String base = RiotTests.rebase(input, assumedRootURITurtle);
                return new RiotEvalTest(entry, base, RDFLanguages.TURTLE, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeEvalTTL)) {
                String base = RiotTests.rebase(input, assumedRootURITurtle);
                return new RiotEvalTest(entry, base, RDFLanguages.TURTLE, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestEvalTriG)) {
                String base = RiotTests.rebase(input, assumedRootURITriG);
                return new RiotEvalTest(entry, base, RDFLanguages.TRIG, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeEvalTriG)) {
                String base = RiotTests.rebase(input, assumedRootURITriG);
                return new RiotEvalTest(entry, base, RDFLanguages.TRIG, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestEvalNT)) {
                String base = entry.getAction().getURI();
                return new RiotEvalTest(entry, base, RDFLanguages.NTRIPLES, true);
            }
            if (testType.equals((Object)VocabLangRDF.TestNegativeEvalNT)) {
                String base = entry.getAction().getURI();
                return new RiotEvalTest(entry, base, RDFLanguages.NTRIPLES, false);
            }
            if (testType.equals((Object)VocabLangRDF.TestEvalRJ)) {
                String base = RiotTests.rebase(input, assumedRootURIex);
                return new RiotEvalTest(entry, base, RDFLanguages.RDFJSON, true);
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            System.err.println("Failed to grok test : " + (String)testName);
            return null;
        }
    }

    private static String rebase(Resource input, String baseIRI) {
        String x = input.getLocalName();
        baseIRI = (String)baseIRI + x;
        return baseIRI;
    }

    static boolean allowWarnings(ManifestEntry testEntry) {
        String fragment = RiotTests.fragment(testEntry.getURI());
        if (fragment == null) {
            return false;
        }
        return fragment.endsWith("UTF8_boundaries") || fragment.endsWith("character_boundaries");
    }

    static String fragment(String uri) {
        if (uri == null) {
            return null;
        }
        int j = uri.lastIndexOf(35);
        String frag = j >= 0 ? uri.substring(j) : uri;
        return frag;
    }
}

