/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.jena.arq.junit.manifest.ManifestEntry;
import org.apache.jena.arq.junit.sparql.tests.QueryTestItem;
import org.apache.jena.arq.junit.sparql.tests.SparqlTestLib;
import org.apache.jena.atlas.lib.Creator;
import org.apache.jena.atlas.logging.Log;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.irix.IRIs;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.DatasetFactory;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryException;
import org.apache.jena.query.QueryExecution;
import org.apache.jena.query.QueryExecutionFactory;
import org.apache.jena.query.ResultSet;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.query.ResultSetFormatter;
import org.apache.jena.query.ResultSetRewindable;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.shared.JenaException;
import org.apache.jena.shared.PrefixMapping;
import org.apache.jena.sparql.SystemARQ;
import org.apache.jena.sparql.core.DatasetGraph;
import org.apache.jena.sparql.core.Transactional;
import org.apache.jena.sparql.core.Var;
import org.apache.jena.sparql.engine.QueryIterator;
import org.apache.jena.sparql.engine.ResultSetStream;
import org.apache.jena.sparql.engine.binding.Binding;
import org.apache.jena.sparql.engine.binding.BindingBuilder;
import org.apache.jena.sparql.engine.iterator.QueryIterPlainWrapper;
import org.apache.jena.sparql.expr.nodevalue.NodeFunctions;
import org.apache.jena.sparql.junit.QueryTestException;
import org.apache.jena.sparql.resultset.ResultSetCompare;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.util.IsoMatcher;
import org.apache.jena.sparql.vocabulary.ResultSetGraphVocab;
import org.apache.jena.sparql.vocabulary.TestManifest;
import org.apache.jena.system.Txn;
import org.apache.jena.util.FileUtils;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;

public class QueryExecTest
implements Runnable {
    private final ManifestEntry testEntry;
    private final SPARQLResult results;
    private final QueryTestItem testItem;
    private final Creator<Dataset> creator;

    public QueryExecTest(ManifestEntry entry, Creator<Dataset> maker) {
        this.testEntry = entry;
        this.testItem = QueryTestItem.create(this.testEntry.getEntry(), TestManifest.QueryEvaluationTest);
        this.results = this.testItem.getResults();
        this.creator = maker;
    }

    public QueryExecTest(ManifestEntry entry) {
        this(entry, (Creator<Dataset>)((Creator)() -> DatasetFactory.createGeneral()));
    }

    @Override
    public void run() {
        try {
            Query query;
            try {
                query = SparqlTestLib.queryFromEntry(this.testEntry);
            }
            catch (QueryException qEx) {
                qEx.printStackTrace(System.err);
                SparqlTestLib.setupFailure("Parse failure: " + qEx.getMessage());
                throw qEx;
            }
            Dataset dataset = this.setUpDataset(query, this.testItem);
            if (dataset == null && !QueryExecTest.doesQueryHaveDataset(query)) {
                SparqlTestLib.setupFailure("No dataset for query");
            }
            if (dataset != null) {
                Txn.executeRead((Transactional)dataset, () -> this.execute(dataset, query));
            } else {
                this.execute(null, query);
            }
        }
        catch (NullPointerException ex) {
            throw ex;
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
            SparqlTestLib.setupFailure("Exception: " + ex.getClass().getName() + ": " + ex.getMessage());
        }
    }

    private void execute(Dataset dataset, Query query) {
        try (QueryExecution qe = dataset == null ? QueryExecutionFactory.create((Query)query) : QueryExecutionFactory.create((Query)query, (Dataset)dataset);){
            if (query.isSelectType()) {
                this.runTestSelect(query, qe);
            } else if (query.isConstructType()) {
                this.runTestConstruct(query, qe);
            } else if (query.isDescribeType()) {
                this.runTestDescribe(query, qe);
            } else if (query.isAskType()) {
                this.runTestAsk(query, qe);
            } else if (query.isJsonType()) {
                throw new UnsupportedOperationException("JSON {} queries not supported");
            }
        }
    }

    protected Dataset setUpDataset(Query query, QueryTestItem testItem) {
        try {
            if (QueryExecTest.doesQueryHaveDataset(query) && QueryExecTest.doesTestItemHaveDataset(testItem) && testItem.getResultFile() != null) {
                Log.warn((Object)this, (String)(testItem.getName() + " : query data source and also in test file"));
            }
            if (QueryExecTest.doesTestItemHaveDataset(testItem)) {
                return this.createDataset(testItem.getDefaultGraphURIs(), testItem.getNamedGraphURIs());
            }
            if (!QueryExecTest.doesQueryHaveDataset(query)) {
                SparqlTestLib.setupFailure("No dataset");
            }
            return null;
        }
        catch (JenaException jEx) {
            SparqlTestLib.setupFailure("JenaException creating data source: " + jEx.getMessage());
            return null;
        }
    }

    protected Dataset createEmptyDataset() {
        return (Dataset)this.creator.create();
    }

    private static boolean doesTestItemHaveDataset(QueryTestItem testItem) {
        boolean r = testItem.getDefaultGraphURIs() != null && testItem.getDefaultGraphURIs().size() > 0 || testItem.getNamedGraphURIs() != null && testItem.getNamedGraphURIs().size() > 0;
        return r;
    }

    private static boolean doesQueryHaveDataset(Query query) {
        return query.hasDatasetDescription();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Dataset createDataset(List<String> defaultGraphURIs, List<String> namedGraphURIs) {
        SystemARQ.UsePlainGraph = true;
        try {
            Dataset ds = this.createEmptyDataset();
            Txn.executeWrite((Transactional)ds, () -> {
                if (defaultGraphURIs != null) {
                    for (String sourceURI : defaultGraphURIs) {
                        SparqlTestLib.parser(sourceURI).parse(ds);
                    }
                }
                if (namedGraphURIs != null) {
                    for (String sourceURI : namedGraphURIs) {
                        String absSourceURI = IRIs.resolve((String)sourceURI);
                        SystemARQ.UsePlainGraph = true;
                        Model m = ds.getNamedModel(absSourceURI);
                        SparqlTestLib.parser(sourceURI).parse(m);
                    }
                }
            });
            Dataset dataset = ds;
            return dataset;
        }
        finally {
            SystemARQ.UsePlainGraph = false;
        }
    }

    private void runTestSelect(Query query, QueryExecution qe) {
        ResultSetRewindable resultsExpected;
        QueryTestItem testItem = QueryTestItem.create(this.testEntry.getEntry(), TestManifest.QueryEvaluationTest);
        ResultSetRewindable resultsActual = ResultSetFactory.makeRewindable((ResultSet)qe.execSelect());
        qe.close();
        if (this.results == null) {
            return;
        }
        if (this.results.isResultSet()) {
            resultsExpected = ResultSetFactory.makeRewindable((ResultSet)this.results.getResultSet());
        } else if (this.results.isModel()) {
            resultsExpected = ResultSetFactory.makeRewindable((Model)this.results.getModel());
        } else {
            Assert.fail((String)"Wrong result type for SELECT query");
            resultsExpected = null;
        }
        if (query.isReduced()) {
            resultsExpected = QueryExecTest.unique(resultsExpected);
            resultsActual = QueryExecTest.unique(resultsActual);
        }
        if (testItem.getResultFile().endsWith(".csv")) {
            resultsActual = this.convertToStrings(resultsActual);
            resultsActual.reset();
            int nActual = ResultSetFormatter.consume((ResultSet)resultsActual);
            int nExpected = ResultSetFormatter.consume((ResultSet)resultsExpected);
            resultsActual.reset();
            resultsExpected.reset();
            Assert.assertEquals((String)"CSV: Different number of rows", (long)nExpected, (long)nActual);
            boolean b = QueryExecTest.resultSetEquivalent(query, resultsExpected, resultsActual);
            if (!b) {
                System.out.println("Manual check of CSV results required: " + testItem.getName());
            }
            return;
        }
        boolean b = QueryExecTest.resultSetEquivalent(query, resultsExpected, resultsActual);
        if (!b) {
            resultsExpected.reset();
            resultsActual.reset();
            boolean b2 = QueryExecTest.resultSetEquivalent(query, resultsExpected, resultsActual);
            this.printFailedResultSetTest(query, qe, resultsExpected, resultsActual);
        }
        Assert.assertTrue((String)"Results do not match", (boolean)b);
    }

    private ResultSetRewindable convertToStrings(ResultSetRewindable resultsActual) {
        ArrayList<Binding> bindings = new ArrayList<Binding>();
        while (resultsActual.hasNext()) {
            Binding b = resultsActual.nextBinding();
            BindingBuilder builder = Binding.builder();
            for (String vn : resultsActual.getResultVars()) {
                Var v = Var.alloc((String)vn);
                Node n = b.get(v);
                Object s = n == null ? "" : (n.isBlank() ? "_:" + n.getBlankNodeLabel() : NodeFunctions.str((Node)n));
                builder.add(v, NodeFactory.createLiteral((String)s));
            }
            bindings.add(builder.build());
        }
        ResultSetStream rs = new ResultSetStream(resultsActual.getResultVars(), null, (Iterator)QueryIterPlainWrapper.create(bindings.iterator()));
        return rs.rewindable();
    }

    private static ResultSetRewindable unique(ResultSetRewindable results) {
        ArrayList<Binding> x = new ArrayList<Binding>();
        HashSet<Binding> seen = new HashSet<Binding>();
        while (results.hasNext()) {
            Binding b = results.nextBinding();
            if (seen.contains(b)) continue;
            seen.add(b);
            x.add(b);
        }
        QueryIterator qIter = QueryIterPlainWrapper.create(x.iterator());
        ResultSetStream rs = new ResultSetStream(results.getResultVars(), ModelFactory.createDefaultModel(), (Iterator)qIter);
        return rs.rewindable();
    }

    private static boolean resultSetEquivalent(Query query, ResultSetRewindable resultsExpected, ResultSetRewindable resultsActual) {
        boolean testByValue = true;
        if (query.isOrdered()) {
            return ResultSetCompare.equalsByValueAndOrder((ResultSet)resultsExpected, (ResultSet)resultsActual);
        }
        return ResultSetCompare.equalsByValue((ResultSet)resultsExpected, (ResultSet)resultsActual);
    }

    private void runTestConstruct(Query query, QueryExecution qe) {
        if (query.isConstructQuad()) {
            Dataset resultActual = qe.execConstructDataset();
            this.compareDatasetResults(resultActual, query);
        } else {
            Model resultsActual = qe.execConstruct();
            this.compareGraphResults(resultsActual, query);
        }
    }

    private void compareGraphResults(Model resultsActual, Query query) {
        if (this.results != null) {
            try {
                Model resultsExpected;
                boolean pass;
                if (!this.results.isGraph()) {
                    SparqlTestLib.testFailure("Expected results are not a graph: " + this.testItem.getName());
                }
                if (!(pass = IsoMatcher.isomorphic((Graph)(resultsExpected = this.results.getModel()).getGraph(), (Graph)this.results.getModel().getGraph()))) {
                    this.printFailedModelTest(query, resultsExpected, resultsActual);
                    Assert.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                String typeName = query.isConstructType() ? "construct" : "describe";
                SparqlTestLib.testFailure("Exception in result testing (" + typeName + "): " + ex);
            }
        }
    }

    private void compareDatasetResults(Dataset resultsActual, Query query) {
        if (this.results != null) {
            try {
                Dataset resultsExpected;
                if (!this.results.isDataset()) {
                    SparqlTestLib.testFailure("Expected results are not a graph: " + this.testItem.getName());
                }
                if (!IsoMatcher.isomorphic((DatasetGraph)(resultsExpected = this.results.getDataset()).asDatasetGraph(), (DatasetGraph)resultsActual.asDatasetGraph())) {
                    this.printFailedDatasetTest(query, resultsExpected, resultsActual);
                    Assert.fail((String)("Results do not match: " + this.testItem.getName()));
                }
            }
            catch (Exception ex) {
                String typeName = query.isConstructType() ? "construct" : "describe";
                Assert.fail((String)("Exception in result testing (" + typeName + "): " + ex));
            }
        }
    }

    private void runTestDescribe(Query query, QueryExecution qe) {
        Model resultsActual = qe.execDescribe();
        this.compareGraphResults(resultsActual, query);
    }

    private void runTestAsk(Query query, QueryExecution qe) {
        boolean result = qe.execAsk();
        if (this.results != null) {
            if (this.results.isBoolean()) {
                boolean b = this.results.getBooleanResult();
                Assert.assertEquals((String)"ASK test results do not match", (Object)b, (Object)result);
            } else {
                Property p;
                Model resultsAsModel = this.results.getModel();
                StmtIterator sIter = this.results.getModel().listStatements(null, RDF.type, (RDFNode)ResultSetGraphVocab.ResultSet);
                if (!sIter.hasNext()) {
                    throw new QueryTestException("Can't find the ASK result");
                }
                Statement s = sIter.nextStatement();
                if (sIter.hasNext()) {
                    throw new QueryTestException("Too many result sets in ASK result");
                }
                Resource r = s.getSubject();
                boolean x = r.getRequiredProperty(p = resultsAsModel.createProperty(ResultSetGraphVocab.getURI() + "boolean")).getBoolean();
                if (x != result) {
                    Assert.assertEquals((String)"ASK test results do not match", (Object)x, (Object)result);
                }
            }
        }
    }

    private void printFailedResultSetTest(Query query, QueryExecution qe, ResultSetRewindable qrExpected, ResultSetRewindable qrActual) {
        PrintStream out = System.out;
        out.println();
        out.println("=======================================");
        out.println("Failure: " + this.description());
        out.println("Query: \n" + query);
        if (qe != null && qe.getDataset() != null) {
            out.println("Data:");
            RDFDataMgr.write((OutputStream)out, (Dataset)qe.getDataset(), (Lang)Lang.TRIG);
        }
        out.println("Got: " + qrActual.size() + " --------------------------------");
        qrActual.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qrActual, (PrefixMapping)query.getPrefixMapping());
        qrActual.reset();
        out.flush();
        out.println("Expected: " + qrExpected.size() + " -----------------------------");
        qrExpected.reset();
        ResultSetFormatter.out((OutputStream)out, (ResultSet)qrExpected, (PrefixMapping)query.getPrefixMapping());
        qrExpected.reset();
        out.println();
        out.flush();
    }

    private void printFailedModelTest(Query query, Model expected, Model results) {
        PrintWriter out = FileUtils.asPrintWriterUTF8((OutputStream)System.out);
        out.println("=======================================");
        out.println("Failure: " + this.description());
        results.write((Writer)out, "TTL");
        out.println("---------------------------------------");
        expected.write((Writer)out, "TTL");
        out.println();
    }

    private void printFailedDatasetTest(Query query, Dataset expected, Dataset results) {
        System.out.println("=======================================");
        System.out.println("Failure: " + this.description());
        RDFDataMgr.write((OutputStream)System.out, (Dataset)results, (Lang)Lang.TRIG);
        System.out.println("---------------------------------------");
        RDFDataMgr.write((OutputStream)System.out, (Dataset)expected, (Lang)Lang.TRIG);
        System.out.println();
    }

    public String toString() {
        if (this.testItem.getName() != null) {
            return this.testItem.getName();
        }
        return this.testEntry.getName();
    }

    private String description() {
        Object tmp = "";
        if (this.testItem.getDefaultGraphURIs() != null) {
            for (String s : this.testItem.getDefaultGraphURIs()) {
                tmp = (String)tmp + s;
            }
        }
        if (this.testItem.getNamedGraphURIs() != null) {
            for (String s : this.testItem.getNamedGraphURIs()) {
                tmp = (String)tmp + s;
            }
        }
        String d = "Test " + this.testItem.getName();
        return d;
    }
}

