/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.arq.junit.sparql.tests;

import java.util.ArrayList;
import java.util.List;
import org.apache.jena.arq.junit.LibTestSetup;
import org.apache.jena.arq.junit.sparql.tests.SparqlTestLib;
import org.apache.jena.graph.Graph;
import org.apache.jena.query.Dataset;
import org.apache.jena.query.ResultSetFactory;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.ModelFactory;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.rdf.model.StmtIterator;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.sparql.graph.GraphFactory;
import org.apache.jena.sparql.junit.QueryTestException;
import org.apache.jena.sparql.resultset.ResultsFormat;
import org.apache.jena.sparql.resultset.SPARQLResult;
import org.apache.jena.sparql.vocabulary.TestManifest;
import org.apache.jena.sparql.vocabulary.TestManifestX;
import org.apache.jena.sparql.vocabulary.VocabTestQuery;
import org.apache.jena.vocabulary.RDF;
import org.apache.jena.vocabulary.RDFS;

public class QueryTestItem {
    static int counter = 0;
    private Resource testResource = null;
    private Resource actionResource = null;
    private String name;
    private boolean buildLuceneIndex = false;
    private String resultFile;
    private String comment;
    private List<String> defaultGraphURIs;
    private List<String> namedGraphURIs;
    private Resource testType = null;
    private String queryFile;

    public static String fakeURI() {
        return "test:" + ++counter;
    }

    public static QueryTestItem create(Resource entry, Resource defaultTestType) {
        return new QueryTestItem(entry, defaultTestType);
    }

    public static QueryTestItem create(String _name, String _queryFile, String _dataFile, String _resultFile) {
        return new QueryTestItem(_name, _queryFile, _dataFile, _resultFile);
    }

    private QueryTestItem(Resource entry, Resource defaultTestType) {
        this.testResource = entry;
        if (!entry.hasProperty(TestManifest.name)) {
            throw new QueryTestException("TestItem with no name (" + entry + ")");
        }
        this.name = this._getName();
        if (!entry.hasProperty(TestManifest.action)) {
            throw new QueryTestException("TestItem '" + this.name + "' with no action");
        }
        this.testType = LibTestSetup.getResource(entry, RDF.type);
        if (this.testType == null) {
            this.testType = defaultTestType;
        }
        this.resultFile = this._getResultFile();
        this.comment = this._getComment();
        this.defaultGraphURIs = this._getDefaultGraphURIs();
        this.namedGraphURIs = this._getNamedGraphsURIs();
        this.queryFile = this._getQueryFile();
        this.buildLuceneIndex = this._getTextIndex();
    }

    private QueryTestItem(String _name, String _queryFile, String _dataFile, String _resultFile) {
        this.name = _name;
        this.queryFile = _queryFile;
        this.defaultGraphURIs = new ArrayList<String>();
        this.defaultGraphURIs.add(_dataFile);
        this.namedGraphURIs = new ArrayList<String>();
        this.resultFile = _resultFile;
        this.comment = "";
    }

    public Resource getResource() {
        return this.testResource;
    }

    public Resource getAction() {
        return this._getAction();
    }

    public Resource getTestType() {
        return this.testType;
    }

    public String getQueryFile() {
        return this.queryFile;
    }

    public String getResultFile() {
        return this.resultFile;
    }

    public SPARQLResult getResults() {
        if (this.resultFile == null) {
            return null;
        }
        ResultsFormat format = ResultsFormat.guessSyntax((String)this.resultFile);
        if (ResultsFormat.isRDFGraphSyntax((ResultsFormat)format)) {
            Graph g = GraphFactory.createPlainGraph();
            SparqlTestLib.parser(this.resultFile).parse(g);
            Model m = ModelFactory.createModelForGraph((Graph)g);
            return new SPARQLResult(m);
        }
        if (ResultsFormat.isDatasetSyntax((ResultsFormat)format)) {
            Dataset d = RDFDataMgr.loadDataset((String)this.resultFile);
            return new SPARQLResult(d);
        }
        SPARQLResult x = ResultSetFactory.result((String)this.resultFile);
        return x;
    }

    public String getName() {
        return this.name;
    }

    public String getURI() {
        if (this.testResource != null && this.testResource.isURIResource()) {
            return this.testResource.getURI();
        }
        return QueryTestItem.fakeURI();
    }

    public String getComment() {
        return this.comment;
    }

    public List<String> getDefaultGraphURIs() {
        return this.defaultGraphURIs;
    }

    public List<String> getNamedGraphURIs() {
        return this.namedGraphURIs;
    }

    public boolean requiresTextIndex() {
        return this.buildLuceneIndex;
    }

    private String _getName() {
        Statement s = this.testResource.getProperty(TestManifest.name);
        String ln = s.getSubject().getLocalName();
        if (s == null) {
            return ln + " <<unset>>";
        }
        return "(" + ln + ") " + s.getString();
    }

    private Resource _getAction() {
        if (this.actionResource == null) {
            this.actionResource = this.testResource.getProperty(TestManifest.action).getResource();
        }
        return this.actionResource;
    }

    private String _getResultFile() {
        try {
            return LibTestSetup.getLiteralOrURI(this.testResource, TestManifest.result);
        }
        catch (RuntimeException ex) {
            return null;
        }
    }

    private String _getComment() {
        Statement s = this.testResource.getProperty(RDFS.comment);
        if (s == null) {
            return null;
        }
        return s.getString();
    }

    private List<String> _getDefaultGraphURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.data);
        while (cIter.hasNext()) {
            Statement stmt = (Statement)cIter.next();
            String df = stmt.getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private List<String> _getNamedGraphsURIs() {
        if (!this._getAction().isAnon()) {
            return null;
        }
        ArrayList<String> l = new ArrayList<String>();
        StmtIterator cIter = this._getAction().listProperties(VocabTestQuery.graphData);
        while (cIter.hasNext()) {
            Statement obj = (Statement)cIter.next();
            String df = obj.getResource().getURI();
            l.add(df);
        }
        cIter.close();
        return l;
    }

    private String _getQueryFile() {
        Resource r = this._getAction();
        if (r.hasProperty(VocabTestQuery.query)) {
            return LibTestSetup.getLiteralOrURI(r, VocabTestQuery.query);
        }
        if (this._getAction().isAnon()) {
            return "[]";
        }
        return this._getAction().getURI();
    }

    private boolean _getTextIndex() {
        Statement s = this.testResource.getProperty(TestManifestX.textIndex);
        if (s == null) {
            return false;
        }
        return s.getString().equalsIgnoreCase("true");
    }

    public String toString() {
        StringBuilder sbuff = new StringBuilder();
        String name = this.getName();
        sbuff.append("Name: " + name);
        if (this.getComment() != null) {
            sbuff.append("    Comment: " + this.getComment());
        }
        return sbuff.toString();
    }
}

