/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.atlas.json;

import org.apache.jena.atlas.json.JSON;
import org.apache.jena.atlas.json.JsonArray;
import org.apache.jena.atlas.json.JsonBoolean;
import org.apache.jena.atlas.json.JsonNumber;
import org.apache.jena.atlas.json.JsonObject;
import org.apache.jena.atlas.json.JsonParseException;
import org.apache.jena.atlas.json.JsonString;
import org.apache.jena.atlas.json.JsonValue;
import org.apache.jena.atlas.json.LibJsonTest;
import org.junit.Test;

public class TestJson {
    @Test
    public void js_value_1() {
        LibJsonTest.read("\"abc\"", (JsonValue)new JsonString("abc"));
    }

    @Test
    public void js_value_2() {
        LibJsonTest.read("123", (JsonValue)JsonNumber.value((long)123L));
    }

    @Test
    public void js_value_3() {
        LibJsonTest.read("true", (JsonValue)new JsonBoolean(true));
    }

    @Test
    public void js_value_4() {
        LibJsonTest.read("{}", (JsonValue)new JsonObject());
    }

    @Test
    public void js_value_5() {
        JsonObject obj = new JsonObject();
        obj.put("a", (JsonValue)JsonNumber.value((long)123L));
        LibJsonTest.read("{ \"a\": 123 }", (JsonValue)obj);
    }

    @Test
    public void js_value_6() {
        JsonArray array = new JsonArray();
        LibJsonTest.read("[ ]", (JsonValue)array);
    }

    @Test
    public void js_value_7() {
        JsonArray array = new JsonArray();
        array.add((JsonValue)JsonNumber.value((long)123L));
        LibJsonTest.read("[ 123 ]", (JsonValue)array);
    }

    @Test
    public void js_value_8() {
        JsonObject obj = new JsonObject();
        JsonArray array = new JsonArray();
        array.add((JsonValue)JsonNumber.value((long)123L));
        obj.put("a", (JsonValue)array);
        LibJsonTest.read("{ \"a\" : [ 123 ] }", (JsonValue)obj);
    }

    @Test(expected=JsonParseException.class)
    public void js_value_9() {
        JSON.parse((String)"[1 2 3]");
    }

    @Test(expected=JsonParseException.class)
    public void js_value_10() {
        JSON.parse((String)"1");
    }

    @Test(expected=JsonParseException.class)
    public void js_value_11() {
        JSON.parse((String)"\"foo\"");
    }

    @Test
    public void js_value_12() {
        JSON.parse((String)"{}");
    }

    @Test
    public void js_value_13() {
        LibJsonTest.read("\"abc\\bd\"", (JsonValue)new JsonString("abc\bd"));
    }
}

