/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.query;

import java.util.concurrent.TimeUnit;
import org.apache.jena.ext.com.google.common.base.Stopwatch;
import org.apache.jena.graph.Triple;
import org.apache.jena.query.Query;
import org.apache.jena.query.QueryFactory;
import org.apache.jena.query.TestQueryCloningEssentials;
import org.apache.jena.sparql.engine.binding.BindingFactory;
import org.apache.jena.sparql.syntax.ElementData;
import org.apache.jena.sparql.syntax.ElementGroup;
import org.apache.jena.sparql.syntax.ElementPathBlock;
import org.apache.jena.vocabulary.RDF;
import org.junit.Assert;
import org.junit.Test;

public class TestQueryCloningCornerCases {
    public void benchmarkQueryClone() {
        String str = "SELECT * { ?s ?p ?o }";
        int n = 1000000;
        Query q = QueryFactory.create((String)str);
        for (int i = 0; i < n; ++i) {
            TestQueryCloningEssentials.slowClone(q);
            q.cloneQuery();
        }
        Stopwatch printParseSw = Stopwatch.createStarted();
        for (int i = 0; i < n; ++i) {
            TestQueryCloningEssentials.slowClone(q);
        }
        printParseSw.stop();
        Stopwatch transformSw = Stopwatch.createStarted();
        for (int i = 0; i < n; ++i) {
            q.cloneQuery();
        }
        transformSw.stop();
        double qpsPrintParse = (double)n / ((double)printParseSw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
        double qpsTransform = (double)n / ((double)transformSw.elapsed(TimeUnit.MILLISECONDS) * 0.001);
        System.out.println("Queries/Second [Print-Parse: " + qpsPrintParse + "], [Transform: " + qpsTransform + "]");
    }

    @Test
    public void testCloneOfDataAndPathBlocks() {
        String str = "PREFIX eg: <http://www.example.org/> SELECT * { ?s eg:foo/eg:bar ?o VALUES (?s ?o) { (eg:baz 1) } }";
        Query query = QueryFactory.create((String)str);
        Query clone = TestQueryCloningEssentials.checkedClone(query);
        Query cloneOfClone = clone.cloneQuery();
        ElementPathBlock elt = (ElementPathBlock)((ElementGroup)cloneOfClone.getQueryPattern()).get(0);
        elt.addTriple(new Triple(RDF.Nodes.type, RDF.Nodes.type, RDF.Nodes.Property));
        Assert.assertNotEquals((Object)elt, (Object)query);
        Assert.assertEquals((Object)query, (Object)clone);
        cloneOfClone = clone.cloneQuery();
        elt = (ElementData)((ElementGroup)cloneOfClone.getQueryPattern()).get(1);
        elt.getRows().add(BindingFactory.empty());
        Assert.assertNotEquals((Object)query, (Object)cloneOfClone);
        Assert.assertEquals((Object)query, (Object)clone);
    }

    @Test
    public void testCloneOfValuesDataBlock() {
        String str = "PREFIX eg: <http://www.example.org/> SELECT * { ?s eg:foo/eg:bar ?o } VALUES (?s ?o) { (eg:baz 1) }";
        Query query = QueryFactory.create((String)str);
        Query clone = TestQueryCloningEssentials.checkedClone(query);
        clone.getValuesData().clear();
        Assert.assertEquals((long)0L, (long)clone.getValuesData().size());
        Assert.assertNotEquals((long)0L, (long)query.getValuesData().size());
        clone.getValuesVariables().clear();
        Assert.assertEquals((long)0L, (long)clone.getValuesVariables().size());
        Assert.assertNotEquals((long)0L, (long)query.getValuesVariables().size());
    }
}

